/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd.proxy;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.client.session.ClientSession;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.internal.transport.sshd.JGitClientSession;
import org.eclipse.jgit.internal.transport.sshd.proxy.StatefulProxyConnector;

public abstract class AbstractClientProxyConnector
implements StatefulProxyConnector {
    private static final long DEFAULT_PROXY_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(30L);
    private Object lock = new Object();
    private boolean done;
    private List<Callable<Void>> bufferedCommands = new ArrayList<Callable<Void>>();
    private AtomicReference<Runnable> unregister = new AtomicReference();
    private long remainingProxyProtocolTime = DEFAULT_PROXY_TIMEOUT_MILLIS;
    private long lastProxyOperationTime = 0L;
    protected final InetSocketAddress remoteAddress;
    protected final InetSocketAddress proxyAddress;
    protected String proxyUser;
    protected char[] proxyPassword;

    public AbstractClientProxyConnector(@NonNull InetSocketAddress proxyAddress, @NonNull InetSocketAddress remoteAddress, String proxyUser, char[] proxyPassword) {
        this.proxyAddress = proxyAddress;
        this.remoteAddress = remoteAddress;
        this.proxyUser = proxyUser;
        this.proxyPassword = proxyPassword == null ? new char[]{} : proxyPassword;
    }

    protected void init(ClientSession session) {
        this.remainingProxyProtocolTime = session.getLongProperty(StatefulProxyConnector.TIMEOUT_PROPERTY, DEFAULT_PROXY_TIMEOUT_MILLIS);
        if (this.remainingProxyProtocolTime <= 0L) {
            this.remainingProxyProtocolTime = DEFAULT_PROXY_TIMEOUT_MILLIS;
        }
        if (!(session instanceof JGitClientSession)) {
            throw new IllegalStateException("Not a JGit session: " + session.getClass().getName());
        }
        JGitClientSession s2 = (JGitClientSession)session;
        this.unregister.set(() -> s2.setProxyHandler(null));
        s2.setProxyHandler(this);
    }

    protected long getTimeout() {
        long elapsed;
        long now;
        long last = this.lastProxyOperationTime;
        this.lastProxyOperationTime = now = System.nanoTime();
        long remaining = this.remainingProxyProtocolTime;
        if (last != 0L && (remaining -= (elapsed = now - last)) < 0L) {
            remaining = 10L;
        }
        this.remainingProxyProtocolTime = remaining;
        return remaining;
    }

    protected void adjustTimeout() {
        this.lastProxyOperationTime = System.nanoTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDone(boolean success) throws Exception {
        List<Callable<Void>> buffered;
        Runnable unset = this.unregister.getAndSet(null);
        if (unset != null) {
            unset.run();
        }
        Object object = this.lock;
        synchronized (object) {
            this.done = true;
            buffered = this.bufferedCommands;
            this.bufferedCommands = null;
        }
        if (success && buffered != null) {
            for (Callable<Void> starter : buffered) {
                starter.call();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runWhenDone(Callable<Void> starter) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (!this.done) {
                this.bufferedCommands.add(starter);
                return;
            }
        }
        starter.call();
    }

    protected void clearPassword() {
        Arrays.fill(this.proxyPassword, '\u0000');
        this.proxyPassword = new char[0];
    }
}

