/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import java.util.List;
import org.eclipse.jgit.diff.DiffConfig;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.RenameDetector;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.StopWalkException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.FollowFilter;
import org.eclipse.jgit.revwalk.RenameCallback;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class TreeRevFilter
extends RevFilter {
    private static final int PARSED = 1;
    private static final int UNINTERESTING = 4;
    private final int rewriteFlag;
    private final TreeWalk pathFilter;

    public TreeRevFilter(RevWalk walker, TreeFilter t2) {
        this(walker, t2, 0);
    }

    TreeRevFilter(RevWalk walker, TreeFilter t2, int rewriteFlag) {
        this.pathFilter = new TreeWalk(walker.reader);
        this.pathFilter.setFilter(t2);
        this.pathFilter.setRecursive(t2.shouldBeRecursive());
        this.rewriteFlag = rewriteFlag;
    }

    @Override
    public RevFilter clone() {
        throw new UnsupportedOperationException();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean include(RevWalk walker, RevCommit c) throws StopWalkException, MissingObjectException, IncorrectObjectTypeException, IOException {
        pList = c.parents;
        nParents = pList.length;
        tw = this.pathFilter;
        trees = new ObjectId[nParents + 1];
        i = 0;
        while (i < nParents) {
            p = c.parents[i];
            if ((p.flags & 1) == 0) {
                p.parseHeaders(walker);
            }
            trees[i] = p.getTree();
            ++i;
        }
        trees[nParents] = c.getTree();
        tw.reset(trees);
        if (nParents == 1) {
            chgs = 0;
            adds = 0;
            while (tw.next()) {
                ++chgs;
                if (tw.getRawMode(0) != 0 || tw.getRawMode(1) == 0) break;
                ++adds;
            }
            if (chgs == 0) {
                c.flags |= this.rewriteFlag;
                return false;
            }
            if (adds > 0 && tw.getFilter() instanceof FollowFilter) {
                this.updateFollowFilter((ObjectId[])trees, ((FollowFilter)tw.getFilter()).cfg);
            }
            return true;
        }
        if (nParents == 0) {
            if (tw.next()) {
                return true;
            }
            c.flags |= this.rewriteFlag;
            return false;
        }
        chgs = new int[nParents];
        adds = new int[nParents];
        while (tw.next()) {
            myMode = tw.getRawMode(nParents);
            i = 0;
            while (i < nParents) {
                pMode = tw.getRawMode(i);
                if (myMode != pMode || !tw.idEqual(i, nParents)) {
                    v0 = i;
                    chgs[v0] = chgs[v0] + 1;
                    if (pMode == 0 && myMode != 0) {
                        v1 = i;
                        adds[v1] = adds[v1] + 1;
                    }
                }
                ++i;
            }
        }
        same = false;
        diff = false;
        i = 0;
        while (i < nParents) {
            if (chgs[i] != 0) ** GOTO lbl62
            p = pList[i];
            if ((p.flags & 4) != 0) {
                same = true;
            } else {
                c.flags |= this.rewriteFlag;
                c.parents = new RevCommit[]{p};
                return false;
lbl62:
                // 1 sources

                if (chgs[i] == adds[i]) {
                    tw.reset((AnyObjectId)pList[i].getTree());
                    if (!tw.next()) {
                        pList[i].parents = RevCommit.NO_PARENTS;
                    }
                }
                diff = true;
            }
            ++i;
        }
        if (diff && !same) {
            return true;
        }
        c.flags |= this.rewriteFlag;
        return false;
    }

    @Override
    public boolean requiresCommitBody() {
        return false;
    }

    private void updateFollowFilter(ObjectId[] trees, DiffConfig cfg) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        TreeWalk tw = this.pathFilter;
        FollowFilter oldFilter = (FollowFilter)tw.getFilter();
        tw.setFilter(TreeFilter.ANY_DIFF);
        tw.reset(trees);
        List<DiffEntry> files = DiffEntry.scan(tw);
        RenameDetector rd = new RenameDetector(tw.getObjectReader(), cfg);
        rd.addAll(files);
        files = rd.compute();
        FollowFilter newFilter = oldFilter;
        for (DiffEntry ent : files) {
            if (!TreeRevFilter.isRename(ent) || !ent.getNewPath().equals(oldFilter.getPath())) continue;
            newFilter = FollowFilter.create(ent.getOldPath(), cfg);
            RenameCallback callback = oldFilter.getRenameCallback();
            if (callback == null) break;
            callback.renamed(ent);
            newFilter.setRenameCallback(callback);
            break;
        }
        tw.setFilter(newFilter);
    }

    private static boolean isRename(DiffEntry ent) {
        return ent.getChangeType() == DiffEntry.ChangeType.RENAME || ent.getChangeType() == DiffEntry.ChangeType.COPY;
    }
}

