/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.inject;

import javax.inject.Inject;
import org.eclipse.sisu.inject.QualifyingStrategy;
import org.eclipse.sisu.inject.RankingFunction;
import shaded.com.google.inject.Binding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultRankingFunction
implements RankingFunction {
    private final int primaryRank;

    public DefaultRankingFunction(int primaryRank) {
        if (primaryRank < 0) {
            throw new IllegalArgumentException("Primary rank must be zero or more");
        }
        this.primaryRank = primaryRank;
    }

    @Inject
    public DefaultRankingFunction() {
        this(0);
    }

    @Override
    public int maxRank() {
        return this.primaryRank;
    }

    @Override
    public <T> int rank(Binding<T> binding) {
        if (QualifyingStrategy.DEFAULT_QUALIFIER.equals(QualifyingStrategy.qualify(binding.getKey()))) {
            return this.primaryRank;
        }
        return this.primaryRank + Integer.MIN_VALUE;
    }
}

