/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.inject;

import java.util.Map;
import org.eclipse.sisu.inject.BindingPublisher;
import org.eclipse.sisu.inject.BindingSubscriber;
import org.eclipse.sisu.inject.HiddenBinding;
import org.eclipse.sisu.inject.ImplementationVisitor;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.inject.RankingFunction;
import org.eclipse.sisu.inject.TypeArguments;
import shaded.com.google.inject.Binding;
import shaded.com.google.inject.Injector;
import shaded.com.google.inject.Key;
import shaded.com.google.inject.TypeLiteral;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InjectorPublisher
implements BindingPublisher {
    private static final TypeLiteral<?> OBJECT_TYPE_LITERAL = TypeLiteral.get(Object.class);
    private final Injector injector;
    private final RankingFunction function;

    public InjectorPublisher(Injector injector, RankingFunction function) {
        this.injector = injector;
        this.function = function;
    }

    public Injector getInjector() {
        return this.injector;
    }

    @Override
    public <T> void subscribe(BindingSubscriber<T> subscriber) {
        TypeLiteral<T> type = subscriber.type();
        this.publishBindings(type, subscriber, null);
        Class<T> clazz = type.getRawType();
        if (clazz != type.getType()) {
            this.publishBindings(TypeLiteral.get(clazz), subscriber, type);
        }
        if (clazz != Object.class) {
            this.publishBindings(OBJECT_TYPE_LITERAL, subscriber, type);
        }
    }

    @Override
    public <T> void unsubscribe(BindingSubscriber<T> subscriber) {
        Map<Key<?>, Binding<?>> ourBindings = this.injector.getBindings();
        for (Binding<T> binding : subscriber.bindings()) {
            if (binding != ourBindings.get(binding.getKey())) continue;
            subscriber.remove(binding);
        }
    }

    public int hashCode() {
        return this.injector.hashCode();
    }

    public boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (rhs instanceof InjectorPublisher) {
            return this.injector.equals(((InjectorPublisher)rhs).injector);
        }
        return false;
    }

    public String toString() {
        return Logs.toString(this.injector);
    }

    static boolean isVisible(Binding<?> binding) {
        return !(binding.getSource() instanceof HiddenBinding);
    }

    private static boolean isAssignableFrom(TypeLiteral<?> superType, Binding<?> binding) {
        Class implementation = (Class)binding.acceptTargetVisitor(ImplementationVisitor.THIS);
        if (implementation != null && superType.getRawType() != implementation) {
            return TypeArguments.isAssignableFrom(superType, TypeLiteral.get(implementation));
        }
        return false;
    }

    private void publishBindings(TypeLiteral searchType, BindingSubscriber subscriber, TypeLiteral superType) {
        for (Binding binding : this.injector.findBindingsByType(searchType)) {
            if (!InjectorPublisher.isVisible(binding) || superType != null && !InjectorPublisher.isAssignableFrom(superType, binding)) continue;
            subscriber.add(binding, this.function.rank(binding));
        }
    }
}

