/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.inject;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import javax.inject.Qualifier;
import shaded.com.google.inject.ImplementedBy;
import shaded.com.google.inject.Key;
import shaded.com.google.inject.ProvidedBy;
import shaded.com.google.inject.TypeLiteral;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeArguments {
    private static final TypeLiteral<?>[] NO_TYPE_LITERALS = new TypeLiteral[0];
    private static final TypeLiteral<?> OBJECT_TYPE_LITERAL = TypeLiteral.get(Object.class);

    private TypeArguments() {
    }

    public static TypeLiteral<?>[] get(TypeLiteral<?> typeLiteral) {
        Type type = typeLiteral.getType();
        if (type instanceof ParameterizedType) {
            Type[] argumentTypes = ((ParameterizedType)type).getActualTypeArguments();
            TypeLiteral[] argumentLiterals = new TypeLiteral[argumentTypes.length];
            int i = 0;
            while (i < argumentTypes.length) {
                argumentLiterals[i] = TypeArguments.expand(argumentTypes[i]);
                ++i;
            }
            return argumentLiterals;
        }
        if (type instanceof GenericArrayType) {
            return new TypeLiteral[]{TypeArguments.expand(((GenericArrayType)type).getGenericComponentType())};
        }
        return NO_TYPE_LITERALS;
    }

    public static TypeLiteral<?> get(TypeLiteral<?> typeLiteral, int index) {
        Type type = typeLiteral.getType();
        if (type instanceof ParameterizedType) {
            return TypeArguments.expand(((ParameterizedType)type).getActualTypeArguments()[index]);
        }
        if (type instanceof GenericArrayType) {
            if (index == 0) {
                return TypeArguments.expand(((GenericArrayType)type).getGenericComponentType());
            }
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return OBJECT_TYPE_LITERAL;
    }

    public static boolean isAssignableFrom(TypeLiteral<?> superLiteral, TypeLiteral<?> subLiteral) {
        Type resolvedType;
        Class<?> superClazz = superLiteral.getRawType();
        if (!superClazz.isAssignableFrom(subLiteral.getRawType())) {
            return false;
        }
        Type superType = superLiteral.getType();
        if (superClazz == superType) {
            return true;
        }
        if (superType instanceof ParameterizedType) {
            Type resolvedType2 = subLiteral.getSupertype(superClazz).getType();
            if (resolvedType2 instanceof ParameterizedType) {
                Type[] superArgs = ((ParameterizedType)superType).getActualTypeArguments();
                Type[] subArgs = ((ParameterizedType)resolvedType2).getActualTypeArguments();
                return TypeArguments.isAssignableFrom(superArgs, subArgs);
            }
        } else if (superType instanceof GenericArrayType && (resolvedType = subLiteral.getSupertype(superClazz).getType()) instanceof GenericArrayType) {
            Type superComponent = ((GenericArrayType)superType).getGenericComponentType();
            Type subComponent = ((GenericArrayType)resolvedType).getGenericComponentType();
            return TypeArguments.isAssignableFrom(new Type[]{superComponent}, new Type[]{subComponent});
        }
        return false;
    }

    public static boolean isConcrete(TypeLiteral<?> literal) {
        return TypeArguments.isConcrete(literal.getRawType());
    }

    public static boolean isConcrete(Class<?> clazz) {
        return !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean isImplicit(TypeLiteral<?> literal) {
        return TypeArguments.isImplicit(literal.getRawType());
    }

    public static boolean isImplicit(Class<?> clazz) {
        return TypeArguments.isConcrete(clazz) || clazz.isAnnotationPresent(ImplementedBy.class) || clazz.isAnnotationPresent(ProvidedBy.class);
    }

    public static <T> Key<T> implicitKey(Class<T> clazz) {
        return Key.get(clazz, Implicit.class);
    }

    private static TypeLiteral<?> expand(Type type) {
        if (type instanceof WildcardType) {
            return TypeLiteral.get(((WildcardType)type).getUpperBounds()[0]);
        }
        if (type instanceof TypeVariable) {
            return TypeLiteral.get(((TypeVariable)type).getBounds()[0]);
        }
        return TypeLiteral.get(type);
    }

    private static boolean isAssignableFrom(Type[] superArgs, Type[] subArgs) {
        int i = 0;
        int len = Math.min(superArgs.length, subArgs.length);
        while (i < len) {
            Type superType = superArgs[i];
            Type subType = subArgs[i];
            if (!(subType instanceof TypeVariable && TypeArguments.isAssignableFrom(TypeArguments.expand(subType), TypeArguments.expand(superType)) || !(superType instanceof WildcardType || superType instanceof TypeVariable ? !TypeArguments.isAssignableFrom(TypeArguments.expand(superType), TypeArguments.expand(subType)) : !superType.equals(subType)))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface Implicit {
    }
}

