/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.inject;

import java.lang.annotation.Annotation;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.Mediator;
import org.eclipse.sisu.inject.BeanCache;
import org.eclipse.sisu.inject.BindingSubscriber;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.inject.QualifyingStrategy;
import shaded.com.google.inject.Binding;
import shaded.com.google.inject.Key;
import shaded.com.google.inject.TypeLiteral;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WatchedBeans<Q extends Annotation, T, W>
implements BindingSubscriber<T> {
    private final BeanCache<Q, T> beans = new BeanCache();
    private final Key<T> key;
    private final Mediator<Q, T, W> mediator;
    private final QualifyingStrategy strategy;
    private final Reference<W> watcherRef;

    WatchedBeans(Key<T> key, Mediator<Q, T, W> mediator, W watcher) {
        this.key = key;
        this.mediator = mediator;
        this.strategy = QualifyingStrategy.selectFor(key);
        this.watcherRef = new WeakReference<W>(watcher);
    }

    @Override
    public TypeLiteral<T> type() {
        return this.key.getTypeLiteral();
    }

    @Override
    public void add(Binding<T> binding, int rank) {
        W watcher;
        Annotation qualifier = this.strategy.qualifies(this.key, binding);
        if (qualifier != null && (watcher = this.watcherRef.get()) != null) {
            BeanEntry<Annotation, T> bean2 = this.beans.create(qualifier, binding, rank);
            try {
                this.mediator.add(bean2, watcher);
            }
            catch (Throwable e) {
                Logs.catchThrowable(e);
                Logs.warn("Problem adding: <> to: " + this.detail(watcher), bean2, e);
            }
        }
    }

    @Override
    public void remove(Binding<T> binding) {
        W watcher;
        BeanEntry<Q, T> bean2 = this.beans.remove(binding);
        if (bean2 != null && (watcher = this.watcherRef.get()) != null) {
            try {
                this.mediator.remove(bean2, watcher);
            }
            catch (Throwable e) {
                Logs.catchThrowable(e);
                Logs.warn("Problem removing: <> from: " + this.detail(watcher), bean2, e);
            }
        }
    }

    @Override
    public Iterable<Binding<T>> bindings() {
        return this.beans.bindings();
    }

    private String detail(Object watcher) {
        return String.valueOf(Logs.identityToString(watcher)) + " via: " + Logs.identityToString(this.mediator);
    }
}

