/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus;

import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.sisu.inject.BeanLocator;
import org.eclipse.sisu.plexus.DefaultPlexusBeans;
import org.eclipse.sisu.plexus.HintedPlexusBeans;
import org.eclipse.sisu.plexus.PlexusBean;
import org.eclipse.sisu.plexus.PlexusBeanLocator;
import org.eclipse.sisu.plexus.RealmFilter;
import shaded.com.google.inject.Key;
import shaded.com.google.inject.TypeLiteral;
import shaded.com.google.inject.name.Named;
import shaded.com.google.inject.name.Names;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public final class DefaultPlexusBeanLocator
implements PlexusBeanLocator {
    private static final String REALM_VISIBILITY = "realm";
    private final BeanLocator beanLocator;
    private final String visibility;

    @Inject
    public DefaultPlexusBeanLocator(BeanLocator beanLocator) {
        this(beanLocator, REALM_VISIBILITY);
    }

    public DefaultPlexusBeanLocator(BeanLocator beanLocator, String visibility) {
        this.beanLocator = beanLocator;
        this.visibility = visibility;
    }

    @Override
    public <T> Iterable<PlexusBean<T>> locate(TypeLiteral<T> role, String ... hints) {
        Key<T> key = hints.length == 1 ? Key.get(role, (Annotation)Names.named(hints[0])) : Key.get(role, Named.class);
        Iterable beans2 = this.beanLocator.locate(key);
        if (REALM_VISIBILITY.equalsIgnoreCase(this.visibility)) {
            beans2 = new RealmFilter(beans2);
        }
        return hints.length <= 1 ? new DefaultPlexusBeans(beans2) : new HintedPlexusBeans(beans2, role, hints);
    }
}

