/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus;

import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Provider;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Startable;
import org.eclipse.sisu.bean.BeanProperty;
import org.eclipse.sisu.bean.PropertyBinding;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.plexus.PlexusBeanManager;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;
import shaded.com.google.inject.spi.ProvisionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlexusLifecycleManager
implements PlexusBeanManager,
ProvisionListener {
    private static final Class<?>[] LIFECYCLE_TYPES = new Class[]{LogEnabled.class, Contextualizable.class, Initializable.class, Startable.class, Disposable.class};
    private final ThreadLocal<List<?>[]> pendingHolder = new ThreadLocal();
    private final List<Startable> startableBeans = new ArrayList<Startable>();
    private final List<Disposable> disposableBeans = new ArrayList<Disposable>();
    private final Logger consoleLogger = new ConsoleLogger();
    private final Provider<Context> plexusContextProvider;
    private final Provider<LoggerManager> plexusLoggerManagerProvider;
    private final Provider<?> slf4jLoggerFactoryProvider;

    public PlexusLifecycleManager(Provider<Context> plexusContextProvider, Provider<LoggerManager> plexusLoggerManagerProvider, Provider<?> slf4jLoggerFactoryProvider) {
        this.plexusContextProvider = plexusContextProvider;
        this.plexusLoggerManagerProvider = plexusLoggerManagerProvider;
        this.slf4jLoggerFactoryProvider = slf4jLoggerFactoryProvider;
    }

    @Override
    public boolean manage(Class<?> clazz) {
        Class<?>[] classArray = LIFECYCLE_TYPES;
        int n = LIFECYCLE_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> lifecycleType = classArray[n2];
            if (lifecycleType.isAssignableFrom(clazz)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public PropertyBinding manage(final BeanProperty property) {
        Class clazz = property.getType().getRawType();
        if ("org.slf4j.Logger".equals(clazz.getName())) {
            return new PropertyBinding(){

                @Override
                public <B> void injectProperty(B bean2) {
                    property.set(bean2, PlexusLifecycleManager.this.getSLF4JLogger(bean2));
                }
            };
        }
        if (Logger.class.equals(clazz)) {
            return new PropertyBinding(){

                @Override
                public <B> void injectProperty(B bean2) {
                    property.set(bean2, PlexusLifecycleManager.this.getPlexusLogger(bean2));
                }
            };
        }
        return null;
    }

    @Override
    public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> pi) {
        List<?>[] holder = this.getPendingHolder();
        if (holder[0] == null) {
            List<?> beans2;
            holder[0] = Collections.EMPTY_LIST;
            try {
                pi.provision();
            }
            finally {
                beans2 = holder[0];
                holder[0] = null;
            }
            int i = 0;
            int size = beans2.size();
            while (i < size) {
                this.manageLifecycle(beans2.get(i));
                ++i;
            }
        }
    }

    @Override
    public boolean manage(Object bean2) {
        if (bean2 instanceof Disposable) {
            PlexusLifecycleManager.synchronizedAdd(this.disposableBeans, (Disposable)bean2);
        }
        if (bean2 instanceof LogEnabled) {
            ((LogEnabled)bean2).enableLogging(this.getPlexusLogger(bean2));
        }
        if (bean2 instanceof Contextualizable || bean2 instanceof Initializable || bean2 instanceof Startable) {
            List<?>[] holder = this.getPendingHolder();
            List<?> beans2 = holder[0];
            if (beans2 == null || beans2.isEmpty()) {
                beans2 = new ArrayList();
                holder[0] = beans2;
            }
            beans2.add(bean2);
        }
        return true;
    }

    @Override
    public boolean unmanage(Object bean2) {
        if (PlexusLifecycleManager.synchronizedRemove(this.startableBeans, bean2)) {
            this.stop((Startable)bean2);
        }
        if (PlexusLifecycleManager.synchronizedRemove(this.disposableBeans, bean2)) {
            this.dispose((Disposable)bean2);
        }
        return true;
    }

    @Override
    public boolean unmanage() {
        Object bean2;
        while ((bean2 = PlexusLifecycleManager.synchronizedRemoveLast(this.startableBeans)) != null) {
            this.stop((Startable)bean2);
        }
        while ((bean2 = PlexusLifecycleManager.synchronizedRemoveLast(this.disposableBeans)) != null) {
            this.dispose((Disposable)bean2);
        }
        this.pendingHolder.remove();
        return true;
    }

    public PlexusBeanManager manageChild() {
        return this;
    }

    Logger getPlexusLogger(Object bean2) {
        String name = bean2.getClass().getName();
        try {
            return this.plexusLoggerManagerProvider.get().getLoggerForComponent(name, null);
        }
        catch (RuntimeException runtimeException) {
            return this.consoleLogger;
        }
    }

    Object getSLF4JLogger(Object bean2) {
        String name = bean2.getClass().getName();
        try {
            return ((ILoggerFactory)this.slf4jLoggerFactoryProvider.get()).getLogger(name);
        }
        catch (RuntimeException runtimeException) {
            return LoggerFactory.getLogger(name);
        }
    }

    private List<?>[] getPendingHolder() {
        List<?>[] holder = this.pendingHolder.get();
        if (holder == null) {
            holder = new List[1];
            this.pendingHolder.set(holder);
        }
        return holder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> boolean synchronizedAdd(List<T> list, T element) {
        List<T> list2 = list;
        synchronized (list2) {
            return list.add(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean synchronizedRemove(List<?> list, Object element) {
        List<?> list2 = list;
        synchronized (list2) {
            return list.remove(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T synchronizedRemoveLast(List<T> list) {
        List<T> list2 = list;
        synchronized (list2) {
            int size = list.size();
            if (size > 0) {
                return list.remove(size - 1);
            }
            return null;
        }
    }

    private void manageLifecycle(Object bean2) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = bean2.getClass();
            while (clazz != null) {
                ClassLoader loader = clazz.getClassLoader();
                if (loader instanceof URLClassLoader) {
                    Thread.currentThread().setContextClassLoader(loader);
                    break;
                }
                clazz = clazz.getSuperclass();
            }
            if (bean2 instanceof Contextualizable) {
                this.contextualize((Contextualizable)bean2);
            }
            if (bean2 instanceof Initializable) {
                this.initialize((Initializable)bean2);
            }
            if (bean2 instanceof Startable) {
                Startable startableBean = (Startable)bean2;
                PlexusLifecycleManager.synchronizedAdd(this.startableBeans, startableBean);
                this.start(startableBean);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    private void contextualize(Contextualizable bean2) {
        Logs.trace("Contextualize: <>", bean2, null);
        try {
            bean2.contextualize(this.plexusContextProvider.get());
        }
        catch (Throwable e) {
            Logs.catchThrowable(e);
            try {
                this.getPlexusLogger(this).warn("Error contextualizing: " + Logs.identityToString(bean2), e);
            }
            finally {
                Logs.throwUnchecked(e);
            }
        }
    }

    private void initialize(Initializable bean2) {
        Logs.trace("Initialize: <>", bean2, null);
        try {
            bean2.initialize();
        }
        catch (Throwable e) {
            Logs.catchThrowable(e);
            try {
                this.getPlexusLogger(this).warn("Error initializing: " + Logs.identityToString(bean2), e);
            }
            finally {
                Logs.throwUnchecked(e);
            }
        }
    }

    private void start(Startable bean2) {
        Logs.trace("Start: <>", bean2, null);
        try {
            bean2.start();
        }
        catch (Throwable e) {
            Logs.catchThrowable(e);
            try {
                this.getPlexusLogger(this).warn("Error starting: " + Logs.identityToString(bean2), e);
            }
            finally {
                Logs.throwUnchecked(e);
            }
        }
    }

    private void stop(Startable bean2) {
        Logs.trace("Stop: <>", bean2, null);
        try {
            bean2.stop();
        }
        catch (Throwable e) {
            Logs.catchThrowable(e);
            try {
                this.getPlexusLogger(this).warn("Problem stopping: " + Logs.identityToString(bean2), e);
            }
            catch (Throwable throwable) {}
            return;
        }
    }

    private void dispose(Disposable bean2) {
        Logs.trace("Dispose: <>", bean2, null);
        try {
            bean2.dispose();
        }
        catch (Throwable e) {
            Logs.catchThrowable(e);
            try {
                this.getPlexusLogger(this).warn("Problem disposing: " + Logs.identityToString(bean2), e);
            }
            catch (Throwable throwable) {}
            return;
        }
    }
}

