/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.space;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.sisu.Mediator;
import org.eclipse.sisu.inject.BeanLocator;
import shaded.com.google.inject.Key;
import shaded.com.google.inject.TypeLiteral;
import shaded.com.google.inject.spi.InjectionListener;
import shaded.com.google.inject.spi.TypeEncounter;
import shaded.com.google.inject.spi.TypeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MediationListener
implements TypeListener,
InjectionListener<Object> {
    private final List<Mediation<?, ?, ?>> mediation = new ArrayList();
    @Inject
    private BeanLocator locator;

    MediationListener() {
    }

    public void mediate(Key key, Mediator mediator, Class watcherType) {
        this.mediation.add(new Mediation(key, mediator, watcherType));
    }

    public <T> void hear(TypeLiteral<T> type, TypeEncounter<T> encounter) {
        for (Mediation<?, ?, ?> m4 : this.mediation) {
            if (!m4.watcherType.isAssignableFrom(type.getRawType())) continue;
            encounter.register(this);
        }
    }

    @Override
    public void afterInjection(Object watcher) {
        for (Mediation<?, ?, ?> m4 : this.mediation) {
            if (!m4.watcherType.isInstance(watcher)) continue;
            this.locator.watch(m4.watchedKey, m4.mediator, watcher);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Mediation<Q extends Annotation, T, W> {
        final Key<T> watchedKey;
        final Mediator<Q, T, W> mediator;
        final Class<W> watcherType;

        Mediation(Key<T> watchedKey, Mediator<Q, T, W> mediator, Class<W> watcherType) {
            this.watchedKey = watchedKey;
            this.mediator = mediator;
            this.watcherType = watcherType;
        }
    }
}

