/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.wire;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.wire.DependencyVerifier;
import shaded.com.google.inject.Binder;
import shaded.com.google.inject.Binding;
import shaded.com.google.inject.Key;
import shaded.com.google.inject.spi.DefaultElementVisitor;
import shaded.com.google.inject.spi.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ElementMerger
extends DefaultElementVisitor<Void> {
    private final DependencyVerifier verifier = new DependencyVerifier();
    private final Set<Key<?>> localKeys = new HashSet();
    private final Binder binder;

    ElementMerger(Binder binder) {
        this.binder = binder;
    }

    @Override
    public <T> Void visit(Binding<T> binding) {
        Key<T> key = binding.getKey();
        if (!this.localKeys.contains(key)) {
            if (binding.acceptTargetVisitor(this.verifier).booleanValue()) {
                this.localKeys.add(key);
                binding.applyTo(this.binder);
            } else {
                Logs.trace("Discard binding: {}", binding, null);
            }
        }
        return null;
    }

    @Override
    public Void visitOther(Element element) {
        element.applyTo(this.binder);
        return null;
    }
}

