/*
 * Decompiled with CFR 0.152.
 */
package org.ndviet.keyword;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.ndviet.library.TakeScreenshot;
import org.ndviet.library.TestObject.ObjectRepository;
import org.ndviet.library.spring.SpringHelpers;
import org.openqa.selenium.WebElement;
import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywordOverload;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.javalib.library.AnnotationLibrary;

@RobotKeywords
public class WebUI
extends AnnotationLibrary {
    public WebUI() {
        super(Arrays.asList("org/ndviet/keyword/WebUI.class"));
        SpringHelpers.getInstance().getBean("WebElementIdentifier");
    }

    @RobotKeyword
    @ArgumentNames(value={"fileName="})
    public void capturePageScreenshot(String fileName) throws Exception {
        TakeScreenshot.capturePageScreenshot(fileName);
    }

    @RobotKeywordOverload
    @ArgumentNames(value={})
    public void capturePageScreenshot() throws Exception {
        TakeScreenshot.capturePageScreenshot(null);
    }

    @RobotKeyword
    @ArgumentNames(value={"fileName="})
    public void captureFullPageScreenshot(String fileName) throws Exception {
        TakeScreenshot.captureFullPageScreenshot(fileName);
    }

    @RobotKeywordOverload
    @ArgumentNames(value={})
    public void captureFullPageScreenshot() throws Exception {
        TakeScreenshot.captureFullPageScreenshot(null);
    }

    @RobotKeyword
    public void openBrowser(String url) throws Exception {
        org.ndviet.library.WebUI.openBrowser(url);
    }

    @RobotKeyword
    public void closeBrowser() {
        org.ndviet.library.WebUI.closeBrowser();
    }

    @RobotKeyword
    @ArgumentNames(value={"objectID", "variables="})
    public WebElement findWebElement(String objectID, Map variables) throws Exception {
        return org.ndviet.library.WebUI.findWebElement(ObjectRepository.findTestObject(objectID));
    }

    @RobotKeywordOverload
    @ArgumentNames(value={"objectID"})
    public WebElement findWebElement(String objectID) throws Exception {
        return org.ndviet.library.WebUI.findWebElement(ObjectRepository.findTestObject(objectID));
    }

    @RobotKeyword
    @ArgumentNames(value={"objectID", "variables="})
    public List<WebElement> findWebElements(String objectID, Map variables) throws Exception {
        return org.ndviet.library.WebUI.findWebElements(ObjectRepository.findTestObject(objectID, variables));
    }

    @RobotKeywordOverload
    @ArgumentNames(value={"objectID"})
    public List<WebElement> findWebElements(String objectID) throws Exception {
        return org.ndviet.library.WebUI.findWebElements(ObjectRepository.findTestObject(objectID));
    }

    @RobotKeyword
    @ArgumentNames(value={"objectID", "variables="})
    public void click(String objectID, Map variables) throws Exception {
        org.ndviet.library.WebUI.click(ObjectRepository.findTestObject(objectID, variables));
    }

    @RobotKeywordOverload
    @ArgumentNames(value={"objectID"})
    public void click(String objectID) throws Exception {
        org.ndviet.library.WebUI.click(ObjectRepository.findTestObject(objectID));
    }

    @RobotKeyword
    @ArgumentNames(value={"objectID", "absolutePath", "variables="})
    public void uploadFile(String objectID, String absolutePath, Map variables) throws Exception {
        org.ndviet.library.WebUI.uploadFile(ObjectRepository.findTestObject(objectID, variables), absolutePath);
    }

    @RobotKeywordOverload
    @ArgumentNames(value={"objectID", "absolutePath"})
    public void uploadFile(String objectID, String absolutePath) throws Exception {
        org.ndviet.library.WebUI.uploadFile(ObjectRepository.findTestObject(objectID), absolutePath);
    }

    @RobotKeyword
    @ArgumentNames(value={"objectID", "text", "variables="})
    public void setText(String objectID, String text, Map variables) throws Exception {
        org.ndviet.library.WebUI.setText(ObjectRepository.findTestObject(objectID, variables), text);
    }

    @RobotKeywordOverload
    @ArgumentNames(value={"objectID", "text"})
    public void setText(String objectID, String text) throws Exception {
        org.ndviet.library.WebUI.setText(ObjectRepository.findTestObject(objectID), text);
    }

    @RobotKeyword
    @ArgumentNames(value={"objectID", "variables="})
    public String getText(String objectID, Map variables) throws Exception {
        return org.ndviet.library.WebUI.getText(ObjectRepository.findTestObject(objectID, variables));
    }

    @RobotKeywordOverload
    @ArgumentNames(value={"objectID"})
    public String getText(String objectID) throws Exception {
        return org.ndviet.library.WebUI.getText(ObjectRepository.findTestObject(objectID));
    }

    @RobotKeyword
    @ArgumentNames(value={"objectID"})
    public List<String> getTexts(String objectID) throws Exception {
        return org.ndviet.library.WebUI.getTexts(ObjectRepository.findTestObject(objectID));
    }

    @RobotKeyword
    @ArgumentNames(value={"objectID", "variables="})
    public void verifyElementPresent(String objectID, Map variables) throws Exception {
        org.ndviet.library.WebUI.verifyElementPresent(ObjectRepository.findTestObject(objectID, variables));
    }

    @RobotKeywordOverload
    @ArgumentNames(value={"objectID"})
    public void verifyElementPresent(String objectID) throws Exception {
        org.ndviet.library.WebUI.verifyElementPresent(ObjectRepository.findTestObject(objectID));
    }

    @RobotKeyword
    @ArgumentNames(value={"objectID", "variables="})
    public void verifyElementNotPresent(String objectID, Map variables) throws Exception {
        org.ndviet.library.WebUI.verifyElementNotPresent(ObjectRepository.findTestObject(objectID, variables));
    }

    @RobotKeywordOverload
    @ArgumentNames(value={"objectID"})
    public void verifyElementNotPresent(String objectID) throws Exception {
        org.ndviet.library.WebUI.verifyElementNotPresent(ObjectRepository.findTestObject(objectID));
    }

    @RobotKeyword
    public void verifyElementHasAttribute() {
    }

    @RobotKeyword
    public void verifyElementNotHasAttribute() {
    }

    @RobotKeyword
    public void verifyElementAttributeValue() {
    }

    @RobotKeyword
    @ArgumentNames(value={"objectID", "variables", "expectValue="})
    public void verifyElementTextEquals(String objectID, Map variables, String expectText) throws Exception {
        org.ndviet.library.WebUI.verifyElementTextEquals(ObjectRepository.findTestObject(objectID, variables), expectText);
    }

    @RobotKeywordOverload
    @ArgumentNames(value={"objectID", "expectValue="})
    public void verifyElementTextEquals(String objectID, String expectText) throws Exception {
        org.ndviet.library.WebUI.verifyElementTextEquals(ObjectRepository.findTestObject(objectID), expectText);
    }

    @RobotKeyword
    @ArgumentNames(value={"objectID", "variables", "expectValue="})
    public void verifyElementTextContains(String objectID, Map variables, String expectText) throws Exception {
        org.ndviet.library.WebUI.verifyElementTextContains(ObjectRepository.findTestObject(objectID, variables), expectText);
    }

    @RobotKeywordOverload
    @ArgumentNames(value={"objectID", "expectValue="})
    public void verifyElementTextContains(String objectID, String expectText) throws Exception {
        org.ndviet.library.WebUI.verifyElementTextContains(ObjectRepository.findTestObject(objectID), expectText);
    }

    @RobotKeyword
    @ArgumentNames(value={"objectID", "variables="})
    public void verifyElementVisible(String objectID, Map variables) throws Exception {
        org.ndviet.library.WebUI.verifyElementVisible(ObjectRepository.findTestObject(objectID, variables));
    }

    @RobotKeywordOverload
    @ArgumentNames(value={"objectID"})
    public void verifyElementVisible(String objectID) throws Exception {
        org.ndviet.library.WebUI.verifyElementVisible(ObjectRepository.findTestObject(objectID));
    }

    @RobotKeyword
    @ArgumentNames(value={"objectID", "variables="})
    public void verifyElementNotVisible(String objectID, Map variables) throws Exception {
        org.ndviet.library.WebUI.verifyElementNotVisible(ObjectRepository.findTestObject(objectID, variables));
    }

    @RobotKeywordOverload
    @ArgumentNames(value={"objectID"})
    public void verifyElementNotVisible(String objectID) throws Exception {
        org.ndviet.library.WebUI.verifyElementNotVisible(ObjectRepository.findTestObject(objectID));
    }

    @RobotKeyword
    @ArgumentNames(value={"objectID", "variables="})
    public void moveToElement(String objectID, Map variables) throws Exception {
        org.ndviet.library.WebUI.moveToElement(ObjectRepository.findTestObject(objectID, variables));
    }

    @RobotKeywordOverload
    @ArgumentNames(value={"objectID"})
    public void moveToElement(String objectID) throws Exception {
        org.ndviet.library.WebUI.moveToElement(ObjectRepository.findTestObject(objectID));
    }

    @RobotKeyword
    @ArgumentNames(value={"objectID", "variables="})
    public void scrollToElement(String objectID, Map variables) throws Exception {
        org.ndviet.library.WebUI.scrollToElement(ObjectRepository.findTestObject(objectID, variables));
    }

    @RobotKeywordOverload
    @ArgumentNames(value={"objectID"})
    public void scrollToElement(String objectID) throws Exception {
        org.ndviet.library.WebUI.scrollToElement(ObjectRepository.findTestObject(objectID));
    }
}

