/*
 * Decompiled with CFR 0.152.
 */
package org.ndviet.library;

import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ndviet.library.configuration.ConfigurationManager;
import org.ndviet.library.file.FileHelpers;
import org.ndviet.library.webui.driver.DriverManager;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.io.FileHandler;
import org.openqa.selenium.remote.RemoteWebDriver;
import ru.yandex.qatools.ashot.AShot;
import ru.yandex.qatools.ashot.Screenshot;
import ru.yandex.qatools.ashot.shooting.ShootingStrategies;

public class TakeScreenshot {
    private static final String m_directory = TakeScreenshot.getScreenshotDirectory();
    private static final String m_fileType = TakeScreenshot.getScreenshotFileType();
    private static final Logger LOGGER = LogManager.getLogger(TakeScreenshot.class);
    private static int m_count = 1;

    public static void resetScreenshotCount() {
        m_count = 1;
    }

    private static String getScreenshotFileType() {
        String fileType = ConfigurationManager.getInstance().getValue("selenium.screenshot.fileType");
        if (fileType != null && !fileType.isEmpty()) {
            return fileType;
        }
        return "png";
    }

    private static String getScreenshotDirectory() {
        String fileType = ConfigurationManager.getInstance().getValue("selenium.screenshot.directory");
        if (fileType != null && !fileType.isEmpty()) {
            return fileType;
        }
        return System.getProperty("user.dir") + File.separator + "target" + File.separator + "screenshots";
    }

    public static String captureFullPageScreenshot(String fileName) throws Exception {
        RemoteWebDriver driver = (RemoteWebDriver)DriverManager.getDriver();
        Screenshot screenshot = new AShot().shootingStrategy(ShootingStrategies.viewportPasting(1000)).takeScreenshot(driver);
        File targetFile = TakeScreenshot.getTargetFile(fileName);
        ImageIO.write((RenderedImage)screenshot.getImage(), m_fileType, targetFile);
        LOGGER.info("Screenshot is available in location: " + targetFile.getPath());
        return targetFile.getPath();
    }

    public static String capturePageScreenshot(String fileName) throws Exception {
        RemoteWebDriver driver = (RemoteWebDriver)DriverManager.getDriver();
        File source = driver.getScreenshotAs(OutputType.FILE);
        File targetFile = TakeScreenshot.getTargetFile(fileName);
        FileHandler.copy(source, targetFile);
        LOGGER.info("Screenshot is available in location: " + targetFile.getPath());
        return targetFile.getPath();
    }

    private static File getTargetFile(String fileName) throws Exception {
        File targetFile;
        FileHelpers.isDirectory(m_directory, true);
        if (fileName == null) {
            targetFile = File.createTempFile("screenshot_", String.format("_SS.%s", m_fileType), new File(m_directory));
        } else {
            targetFile = new File(m_directory + File.separator + String.format("%s_SS_%s.%s", fileName, m_count, m_fileType));
            ++m_count;
        }
        return targetFile;
    }
}

