/*
 * Decompiled with CFR 0.152.
 */
package org.ndviet.library.yaml;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.ndviet.library.file.FileHelpers;
import org.yaml.snakeyaml.Yaml;

public class YamlUtils {
    public static LinkedHashMap readYaml(String filePath) throws Exception {
        Yaml yaml = new Yaml();
        FileInputStream input = new FileInputStream(filePath);
        LinkedHashMap map = (LinkedHashMap)yaml.load(input);
        return map;
    }

    public static LinkedHashMap readAllYaml(String filePath) throws Exception {
        Yaml yaml = new Yaml();
        LinkedHashMap multiYaml = new LinkedHashMap();
        FileInputStream input = new FileInputStream(filePath);
        for (Object o : yaml.loadAll(input)) {
            multiYaml.putAll((LinkedHashMap)o);
        }
        return multiYaml;
    }

    public static LinkedHashMap readAllYaml(String filePath, String keyName, String valueName) throws Exception {
        Yaml yaml = new Yaml();
        LinkedHashMap<String, String> multiYaml = new LinkedHashMap<String, String>();
        FileInputStream input = new FileInputStream(filePath);
        for (Object o : yaml.loadAll(input)) {
            LinkedHashMap map = (LinkedHashMap)o;
            multiYaml.put(map.get(keyName).toString(), map.get(valueName).toString());
        }
        return multiYaml;
    }

    public static LinkedHashMap readAllYamlInDirectory(String directory) throws Exception {
        LinkedHashMap multiYaml = new LinkedHashMap();
        List<String> files = new ArrayList<String>();
        files = FileHelpers.recursiveGetListFiles(directory, files, "y.*ml");
        for (String filePath : files) {
            multiYaml.putAll(YamlUtils.readAllYaml(filePath));
        }
        return multiYaml;
    }
}

