/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.network;

import java.lang.reflect.Type;
import java.util.Optional;
import org.openqa.selenium.bidi.network.BytesValue;
import org.openqa.selenium.json.JsonInput;

public class Cookie {
    private final String name;
    private final BytesValue value;
    private final String domain;
    private final String path;
    private final long size;
    private final boolean isSecure;
    private final boolean isHttpOnly;
    private final SameSite sameSite;
    private final Optional<Long> expiry;

    public Cookie(String name, BytesValue value, String domain, String path, long size, boolean isSecure, boolean httpOnly, SameSite sameSite, Optional<Long> expiry) {
        this.name = name;
        this.value = value;
        this.domain = domain;
        this.path = path;
        this.size = size;
        this.isSecure = isSecure;
        this.isHttpOnly = httpOnly;
        this.sameSite = sameSite;
        this.expiry = expiry;
    }

    public static Cookie fromJson(JsonInput input) {
        String name = null;
        BytesValue value = null;
        String domain = null;
        String path = null;
        long size = 0L;
        boolean isSecure = false;
        boolean isHttpOnly = false;
        SameSite sameSite = null;
        Optional expiry = Optional.empty();
        input.beginObject();
        block22: while (input.hasNext()) {
            switch (input.nextName()) {
                case "name": {
                    name = (String)input.read((Type)((Object)String.class));
                    continue block22;
                }
                case "value": {
                    value = (BytesValue)input.read((Type)((Object)BytesValue.class));
                    continue block22;
                }
                case "domain": {
                    domain = (String)input.read((Type)((Object)String.class));
                    continue block22;
                }
                case "path": {
                    path = (String)input.read((Type)((Object)String.class));
                    continue block22;
                }
                case "size": {
                    size = (Long)input.read((Type)((Object)Long.class));
                    continue block22;
                }
                case "secure": {
                    isSecure = (Boolean)input.read((Type)((Object)Boolean.class));
                    continue block22;
                }
                case "isHttpOnly": {
                    isHttpOnly = (Boolean)input.read((Type)((Object)Boolean.class));
                    continue block22;
                }
                case "sameSite": {
                    String sameSiteValue = (String)input.read((Type)((Object)String.class));
                    sameSite = SameSite.findByName(sameSiteValue);
                    continue block22;
                }
                case "expiry": {
                    expiry = (Optional)input.read((Type)((Object)Long.class));
                    continue block22;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Cookie(name, value, domain, path, size, isSecure, isHttpOnly, sameSite, expiry);
    }

    public String getName() {
        return this.name;
    }

    public BytesValue getValue() {
        return this.value;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getPath() {
        return this.path;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public boolean isHttpOnly() {
        return this.isHttpOnly;
    }

    public SameSite getSameSite() {
        return this.sameSite;
    }

    public Optional<Long> getExpiry() {
        return this.expiry;
    }

    public static enum SameSite {
        STRICT("strict"),
        LAX("lax"),
        NONE("none");

        private final String type;

        private SameSite(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }

        public static SameSite findByName(String name) {
            SameSite result = null;
            for (SameSite type : SameSite.values()) {
                if (!type.toString().equalsIgnoreCase(name)) continue;
                result = type;
                break;
            }
            return result;
        }
    }
}

