/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v120.animation;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v120.runtime.model.RemoteObject;

@Beta
public class Animation {
    public static Command<Void> disable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("Animation.disable", Map.copyOf(params));
    }

    public static Command<Void> enable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("Animation.enable", Map.copyOf(params));
    }

    public static Command<Number> getCurrentTime(String id) {
        Objects.requireNonNull(id, "id is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("id", id);
        return new Command<Number>("Animation.getCurrentTime", Map.copyOf(params), ConverterFunctions.map("currentTime", Number.class));
    }

    public static Command<Number> getPlaybackRate() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Number>("Animation.getPlaybackRate", Map.copyOf(params), ConverterFunctions.map("playbackRate", Number.class));
    }

    public static Command<Void> releaseAnimations(List<String> animations) {
        Objects.requireNonNull(animations, "animations is required");
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        params.put("animations", animations);
        return new Command<Void>("Animation.releaseAnimations", Map.copyOf(params));
    }

    public static Command<RemoteObject> resolveAnimation(String animationId) {
        Objects.requireNonNull(animationId, "animationId is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("animationId", animationId);
        return new Command<RemoteObject>("Animation.resolveAnimation", Map.copyOf(params), ConverterFunctions.map("remoteObject", RemoteObject.class));
    }

    public static Command<Void> seekAnimations(List<String> animations, Number currentTime) {
        Objects.requireNonNull(animations, "animations is required");
        Objects.requireNonNull(currentTime, "currentTime is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("animations", animations);
        params.put("currentTime", currentTime);
        return new Command<Void>("Animation.seekAnimations", Map.copyOf(params));
    }

    public static Command<Void> setPaused(List<String> animations, Boolean paused) {
        Objects.requireNonNull(animations, "animations is required");
        Objects.requireNonNull(paused, "paused is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("animations", animations);
        params.put("paused", paused);
        return new Command<Void>("Animation.setPaused", Map.copyOf(params));
    }

    public static Command<Void> setPlaybackRate(Number playbackRate) {
        Objects.requireNonNull(playbackRate, "playbackRate is required");
        LinkedHashMap<String, Number> params = new LinkedHashMap<String, Number>();
        params.put("playbackRate", playbackRate);
        return new Command<Void>("Animation.setPlaybackRate", Map.copyOf(params));
    }

    public static Command<Void> setTiming(String animationId, Number duration, Number delay) {
        Objects.requireNonNull(animationId, "animationId is required");
        Objects.requireNonNull(duration, "duration is required");
        Objects.requireNonNull(delay, "delay is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("animationId", animationId);
        params.put("duration", duration);
        params.put("delay", delay);
        return new Command<Void>("Animation.setTiming", Map.copyOf(params));
    }

    public static Event<String> animationCanceled() {
        return new Event<String>("Animation.animationCanceled", ConverterFunctions.map("id", String.class));
    }

    public static Event<String> animationCreated() {
        return new Event<String>("Animation.animationCreated", ConverterFunctions.map("id", String.class));
    }

    public static Event<org.openqa.selenium.devtools.v120.animation.model.Animation> animationStarted() {
        return new Event<org.openqa.selenium.devtools.v120.animation.model.Animation>("Animation.animationStarted", ConverterFunctions.map("animation", org.openqa.selenium.devtools.v120.animation.model.Animation.class));
    }
}

