/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v120.emulation.model;

import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@Beta
public class SensorMetadata {
    private final Optional<Boolean> available;
    private final Optional<Number> minimumFrequency;
    private final Optional<Number> maximumFrequency;

    public SensorMetadata(Optional<Boolean> available, Optional<Number> minimumFrequency, Optional<Number> maximumFrequency) {
        this.available = available;
        this.minimumFrequency = minimumFrequency;
        this.maximumFrequency = maximumFrequency;
    }

    public Optional<Boolean> getAvailable() {
        return this.available;
    }

    public Optional<Number> getMinimumFrequency() {
        return this.minimumFrequency;
    }

    public Optional<Number> getMaximumFrequency() {
        return this.maximumFrequency;
    }

    private static SensorMetadata fromJson(JsonInput input) {
        Optional<Boolean> available = Optional.empty();
        Optional<Number> minimumFrequency = Optional.empty();
        Optional<Number> maximumFrequency = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "available": {
                    available = Optional.ofNullable(input.nextBoolean());
                    continue block10;
                }
                case "minimumFrequency": {
                    minimumFrequency = Optional.ofNullable(input.nextNumber());
                    continue block10;
                }
                case "maximumFrequency": {
                    maximumFrequency = Optional.ofNullable(input.nextNumber());
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new SensorMetadata(available, minimumFrequency, maximumFrequency);
    }
}

