/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v120.performancetimeline.model;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v120.network.model.TimeSinceEpoch;
import org.openqa.selenium.devtools.v120.page.model.FrameId;
import org.openqa.selenium.devtools.v120.performancetimeline.model.LargestContentfulPaint;
import org.openqa.selenium.devtools.v120.performancetimeline.model.LayoutShift;
import org.openqa.selenium.json.JsonInput;

public class TimelineEvent {
    private final FrameId frameId;
    private final String type;
    private final String name;
    private final TimeSinceEpoch time;
    private final Optional<Number> duration;
    private final Optional<LargestContentfulPaint> lcpDetails;
    private final Optional<LayoutShift> layoutShiftDetails;

    public TimelineEvent(FrameId frameId, String type, String name, TimeSinceEpoch time, Optional<Number> duration, Optional<LargestContentfulPaint> lcpDetails, Optional<LayoutShift> layoutShiftDetails) {
        this.frameId = Objects.requireNonNull(frameId, "frameId is required");
        this.type = Objects.requireNonNull(type, "type is required");
        this.name = Objects.requireNonNull(name, "name is required");
        this.time = Objects.requireNonNull(time, "time is required");
        this.duration = duration;
        this.lcpDetails = lcpDetails;
        this.layoutShiftDetails = layoutShiftDetails;
    }

    public FrameId getFrameId() {
        return this.frameId;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public TimeSinceEpoch getTime() {
        return this.time;
    }

    public Optional<Number> getDuration() {
        return this.duration;
    }

    public Optional<LargestContentfulPaint> getLcpDetails() {
        return this.lcpDetails;
    }

    public Optional<LayoutShift> getLayoutShiftDetails() {
        return this.layoutShiftDetails;
    }

    private static TimelineEvent fromJson(JsonInput input) {
        FrameId frameId = null;
        String type = null;
        String name = null;
        TimeSinceEpoch time = null;
        Optional<Number> duration = Optional.empty();
        Optional<LargestContentfulPaint> lcpDetails = Optional.empty();
        Optional<LayoutShift> layoutShiftDetails = Optional.empty();
        input.beginObject();
        block18: while (input.hasNext()) {
            switch (input.nextName()) {
                case "frameId": {
                    frameId = (FrameId)input.read((Type)((Object)FrameId.class));
                    continue block18;
                }
                case "type": {
                    type = input.nextString();
                    continue block18;
                }
                case "name": {
                    name = input.nextString();
                    continue block18;
                }
                case "time": {
                    time = (TimeSinceEpoch)input.read((Type)((Object)TimeSinceEpoch.class));
                    continue block18;
                }
                case "duration": {
                    duration = Optional.ofNullable(input.nextNumber());
                    continue block18;
                }
                case "lcpDetails": {
                    lcpDetails = Optional.ofNullable((LargestContentfulPaint)input.read((Type)((Object)LargestContentfulPaint.class)));
                    continue block18;
                }
                case "layoutShiftDetails": {
                    layoutShiftDetails = Optional.ofNullable((LayoutShift)input.read((Type)((Object)LayoutShift.class)));
                    continue block18;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new TimelineEvent(frameId, type, name, time, duration, lcpDetails, layoutShiftDetails);
    }
}

