/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v121.domstorage;

import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v121.domstorage.model.DomStorageItemAdded;
import org.openqa.selenium.devtools.v121.domstorage.model.DomStorageItemRemoved;
import org.openqa.selenium.devtools.v121.domstorage.model.DomStorageItemUpdated;
import org.openqa.selenium.devtools.v121.domstorage.model.Item;
import org.openqa.selenium.devtools.v121.domstorage.model.StorageId;

@Beta
public class DOMStorage {
    public static Command<Void> clear(StorageId storageId) {
        Objects.requireNonNull(storageId, "storageId is required");
        LinkedHashMap<String, StorageId> params = new LinkedHashMap<String, StorageId>();
        params.put("storageId", storageId);
        return new Command<Void>("DOMStorage.clear", Map.copyOf(params));
    }

    public static Command<Void> disable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("DOMStorage.disable", Map.copyOf(params));
    }

    public static Command<Void> enable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("DOMStorage.enable", Map.copyOf(params));
    }

    public static Command<List<Item>> getDOMStorageItems(StorageId storageId) {
        Objects.requireNonNull(storageId, "storageId is required");
        LinkedHashMap<String, StorageId> params = new LinkedHashMap<String, StorageId>();
        params.put("storageId", storageId);
        return new Command<List<Item>>("DOMStorage.getDOMStorageItems", Map.copyOf(params), ConverterFunctions.map("entries", input -> input.readArray((Type)((Object)Item.class))));
    }

    public static Command<Void> removeDOMStorageItem(StorageId storageId, String key) {
        Objects.requireNonNull(storageId, "storageId is required");
        Objects.requireNonNull(key, "key is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("storageId", storageId);
        params.put("key", key);
        return new Command<Void>("DOMStorage.removeDOMStorageItem", Map.copyOf(params));
    }

    public static Command<Void> setDOMStorageItem(StorageId storageId, String key, String value) {
        Objects.requireNonNull(storageId, "storageId is required");
        Objects.requireNonNull(key, "key is required");
        Objects.requireNonNull(value, "value is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("storageId", storageId);
        params.put("key", key);
        params.put("value", value);
        return new Command<Void>("DOMStorage.setDOMStorageItem", Map.copyOf(params));
    }

    public static Event<DomStorageItemAdded> domStorageItemAdded() {
        return new Event<DomStorageItemAdded>("DOMStorage.domStorageItemAdded", input -> (DomStorageItemAdded)input.read((Type)((Object)DomStorageItemAdded.class)));
    }

    public static Event<DomStorageItemRemoved> domStorageItemRemoved() {
        return new Event<DomStorageItemRemoved>("DOMStorage.domStorageItemRemoved", input -> (DomStorageItemRemoved)input.read((Type)((Object)DomStorageItemRemoved.class)));
    }

    public static Event<DomStorageItemUpdated> domStorageItemUpdated() {
        return new Event<DomStorageItemUpdated>("DOMStorage.domStorageItemUpdated", input -> (DomStorageItemUpdated)input.read((Type)((Object)DomStorageItemUpdated.class)));
    }

    public static Event<StorageId> domStorageItemsCleared() {
        return new Event<StorageId>("DOMStorage.domStorageItemsCleared", ConverterFunctions.map("storageId", StorageId.class));
    }
}

