/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v121.network.model;

import java.util.Arrays;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

@Beta
public enum ContentSecurityPolicySource {
    HTTP("HTTP"),
    META("Meta");

    private String value;

    private ContentSecurityPolicySource(String value) {
        this.value = value;
    }

    public static ContentSecurityPolicySource fromString(String s2) {
        return Arrays.stream(ContentSecurityPolicySource.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within ContentSecurityPolicySource "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static ContentSecurityPolicySource fromJson(JsonInput input) {
        return ContentSecurityPolicySource.fromString(input.nextString());
    }
}

