/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v121.page.model;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.json.JsonInput;

public class WindowOpen {
    private final String url;
    private final String windowName;
    private final List<String> windowFeatures;
    private final Boolean userGesture;

    public WindowOpen(String url, String windowName, List<String> windowFeatures, Boolean userGesture) {
        this.url = Objects.requireNonNull(url, "url is required");
        this.windowName = Objects.requireNonNull(windowName, "windowName is required");
        this.windowFeatures = Objects.requireNonNull(windowFeatures, "windowFeatures is required");
        this.userGesture = Objects.requireNonNull(userGesture, "userGesture is required");
    }

    public String getUrl() {
        return this.url;
    }

    public String getWindowName() {
        return this.windowName;
    }

    public List<String> getWindowFeatures() {
        return this.windowFeatures;
    }

    public Boolean getUserGesture() {
        return this.userGesture;
    }

    private static WindowOpen fromJson(JsonInput input) {
        String url = null;
        String windowName = null;
        List windowFeatures = null;
        Boolean userGesture = false;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "url": {
                    url = input.nextString();
                    continue block12;
                }
                case "windowName": {
                    windowName = input.nextString();
                    continue block12;
                }
                case "windowFeatures": {
                    windowFeatures = input.readArray((Type)((Object)String.class));
                    continue block12;
                }
                case "userGesture": {
                    userGesture = input.nextBoolean();
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new WindowOpen(url, windowName, windowFeatures, userGesture);
    }
}

