/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v122.domdebugger;

import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.v122.dom.model.NodeId;
import org.openqa.selenium.devtools.v122.domdebugger.model.CSPViolationType;
import org.openqa.selenium.devtools.v122.domdebugger.model.DOMBreakpointType;
import org.openqa.selenium.devtools.v122.domdebugger.model.EventListener;
import org.openqa.selenium.devtools.v122.runtime.model.RemoteObjectId;

public class DOMDebugger {
    public static Command<List<EventListener>> getEventListeners(RemoteObjectId objectId, Optional<Integer> depth, Optional<Boolean> pierce) {
        Objects.requireNonNull(objectId, "objectId is required");
        LinkedHashMap<String, RemoteObjectId> params = new LinkedHashMap<String, RemoteObjectId>();
        params.put("objectId", objectId);
        depth.ifPresent(p -> params.put("depth", (RemoteObjectId)p));
        pierce.ifPresent(p -> params.put("pierce", (RemoteObjectId)p));
        return new Command<List<EventListener>>("DOMDebugger.getEventListeners", Map.copyOf(params), ConverterFunctions.map("listeners", input -> input.readArray((Type)((Object)EventListener.class))));
    }

    public static Command<Void> removeDOMBreakpoint(NodeId nodeId, DOMBreakpointType type) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(type, "type is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("nodeId", nodeId);
        params.put("type", (Object)type);
        return new Command<Void>("DOMDebugger.removeDOMBreakpoint", Map.copyOf(params));
    }

    public static Command<Void> removeEventListenerBreakpoint(String eventName, Optional<String> targetName) {
        Objects.requireNonNull(eventName, "eventName is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("eventName", eventName);
        targetName.ifPresent(p -> params.put("targetName", (String)p));
        return new Command<Void>("DOMDebugger.removeEventListenerBreakpoint", Map.copyOf(params));
    }

    @Beta
    @Deprecated
    public static Command<Void> removeInstrumentationBreakpoint(String eventName) {
        Objects.requireNonNull(eventName, "eventName is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("eventName", eventName);
        return new Command<Void>("DOMDebugger.removeInstrumentationBreakpoint", Map.copyOf(params));
    }

    public static Command<Void> removeXHRBreakpoint(String url) {
        Objects.requireNonNull(url, "url is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("url", url);
        return new Command<Void>("DOMDebugger.removeXHRBreakpoint", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setBreakOnCSPViolation(List<CSPViolationType> violationTypes) {
        Objects.requireNonNull(violationTypes, "violationTypes is required");
        LinkedHashMap<String, List<CSPViolationType>> params = new LinkedHashMap<String, List<CSPViolationType>>();
        params.put("violationTypes", violationTypes);
        return new Command<Void>("DOMDebugger.setBreakOnCSPViolation", Map.copyOf(params));
    }

    public static Command<Void> setDOMBreakpoint(NodeId nodeId, DOMBreakpointType type) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(type, "type is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("nodeId", nodeId);
        params.put("type", (Object)type);
        return new Command<Void>("DOMDebugger.setDOMBreakpoint", Map.copyOf(params));
    }

    public static Command<Void> setEventListenerBreakpoint(String eventName, Optional<String> targetName) {
        Objects.requireNonNull(eventName, "eventName is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("eventName", eventName);
        targetName.ifPresent(p -> params.put("targetName", (String)p));
        return new Command<Void>("DOMDebugger.setEventListenerBreakpoint", Map.copyOf(params));
    }

    @Beta
    @Deprecated
    public static Command<Void> setInstrumentationBreakpoint(String eventName) {
        Objects.requireNonNull(eventName, "eventName is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("eventName", eventName);
        return new Command<Void>("DOMDebugger.setInstrumentationBreakpoint", Map.copyOf(params));
    }

    public static Command<Void> setXHRBreakpoint(String url) {
        Objects.requireNonNull(url, "url is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("url", url);
        return new Command<Void>("DOMDebugger.setXHRBreakpoint", Map.copyOf(params));
    }
}

