/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v122.storage.model;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v122.network.model.TimeSinceEpoch;
import org.openqa.selenium.devtools.v122.storage.model.AttributionReportingAggregationKeysEntry;
import org.openqa.selenium.devtools.v122.storage.model.AttributionReportingFilterDataEntry;
import org.openqa.selenium.devtools.v122.storage.model.AttributionReportingSourceType;
import org.openqa.selenium.devtools.v122.storage.model.AttributionReportingTriggerDataMatching;
import org.openqa.selenium.devtools.v122.storage.model.AttributionReportingTriggerSpec;
import org.openqa.selenium.devtools.v122.storage.model.SignedInt64AsBase10;
import org.openqa.selenium.devtools.v122.storage.model.UnsignedInt64AsBase10;
import org.openqa.selenium.json.JsonInput;

@Beta
public class AttributionReportingSourceRegistration {
    private final TimeSinceEpoch time;
    private final Integer expiry;
    private final List<AttributionReportingTriggerSpec> triggerSpecs;
    private final Integer aggregatableReportWindow;
    private final AttributionReportingSourceType type;
    private final String sourceOrigin;
    private final String reportingOrigin;
    private final List<String> destinationSites;
    private final UnsignedInt64AsBase10 eventId;
    private final SignedInt64AsBase10 priority;
    private final List<AttributionReportingFilterDataEntry> filterData;
    private final List<AttributionReportingAggregationKeysEntry> aggregationKeys;
    private final Optional<UnsignedInt64AsBase10> debugKey;
    private final AttributionReportingTriggerDataMatching triggerDataMatching;

    public AttributionReportingSourceRegistration(TimeSinceEpoch time, Integer expiry, List<AttributionReportingTriggerSpec> triggerSpecs, Integer aggregatableReportWindow, AttributionReportingSourceType type, String sourceOrigin, String reportingOrigin, List<String> destinationSites, UnsignedInt64AsBase10 eventId, SignedInt64AsBase10 priority, List<AttributionReportingFilterDataEntry> filterData, List<AttributionReportingAggregationKeysEntry> aggregationKeys, Optional<UnsignedInt64AsBase10> debugKey, AttributionReportingTriggerDataMatching triggerDataMatching) {
        this.time = Objects.requireNonNull(time, "time is required");
        this.expiry = Objects.requireNonNull(expiry, "expiry is required");
        this.triggerSpecs = Objects.requireNonNull(triggerSpecs, "triggerSpecs is required");
        this.aggregatableReportWindow = Objects.requireNonNull(aggregatableReportWindow, "aggregatableReportWindow is required");
        this.type = Objects.requireNonNull(type, "type is required");
        this.sourceOrigin = Objects.requireNonNull(sourceOrigin, "sourceOrigin is required");
        this.reportingOrigin = Objects.requireNonNull(reportingOrigin, "reportingOrigin is required");
        this.destinationSites = Objects.requireNonNull(destinationSites, "destinationSites is required");
        this.eventId = Objects.requireNonNull(eventId, "eventId is required");
        this.priority = Objects.requireNonNull(priority, "priority is required");
        this.filterData = Objects.requireNonNull(filterData, "filterData is required");
        this.aggregationKeys = Objects.requireNonNull(aggregationKeys, "aggregationKeys is required");
        this.debugKey = debugKey;
        this.triggerDataMatching = Objects.requireNonNull(triggerDataMatching, "triggerDataMatching is required");
    }

    public TimeSinceEpoch getTime() {
        return this.time;
    }

    public Integer getExpiry() {
        return this.expiry;
    }

    public List<AttributionReportingTriggerSpec> getTriggerSpecs() {
        return this.triggerSpecs;
    }

    public Integer getAggregatableReportWindow() {
        return this.aggregatableReportWindow;
    }

    public AttributionReportingSourceType getType() {
        return this.type;
    }

    public String getSourceOrigin() {
        return this.sourceOrigin;
    }

    public String getReportingOrigin() {
        return this.reportingOrigin;
    }

    public List<String> getDestinationSites() {
        return this.destinationSites;
    }

    public UnsignedInt64AsBase10 getEventId() {
        return this.eventId;
    }

    public SignedInt64AsBase10 getPriority() {
        return this.priority;
    }

    public List<AttributionReportingFilterDataEntry> getFilterData() {
        return this.filterData;
    }

    public List<AttributionReportingAggregationKeysEntry> getAggregationKeys() {
        return this.aggregationKeys;
    }

    public Optional<UnsignedInt64AsBase10> getDebugKey() {
        return this.debugKey;
    }

    public AttributionReportingTriggerDataMatching getTriggerDataMatching() {
        return this.triggerDataMatching;
    }

    private static AttributionReportingSourceRegistration fromJson(JsonInput input) {
        TimeSinceEpoch time = null;
        Integer expiry = 0;
        List<AttributionReportingTriggerSpec> triggerSpecs = null;
        Integer aggregatableReportWindow = 0;
        AttributionReportingSourceType type = null;
        String sourceOrigin = null;
        String reportingOrigin = null;
        List<String> destinationSites = null;
        UnsignedInt64AsBase10 eventId = null;
        SignedInt64AsBase10 priority = null;
        List<AttributionReportingFilterDataEntry> filterData = null;
        List<AttributionReportingAggregationKeysEntry> aggregationKeys = null;
        Optional<UnsignedInt64AsBase10> debugKey = Optional.empty();
        AttributionReportingTriggerDataMatching triggerDataMatching = null;
        input.beginObject();
        block32: while (input.hasNext()) {
            switch (input.nextName()) {
                case "time": {
                    time = (TimeSinceEpoch)input.read((Type)((Object)TimeSinceEpoch.class));
                    continue block32;
                }
                case "expiry": {
                    expiry = input.nextNumber().intValue();
                    continue block32;
                }
                case "triggerSpecs": {
                    triggerSpecs = input.readArray((Type)((Object)AttributionReportingTriggerSpec.class));
                    continue block32;
                }
                case "aggregatableReportWindow": {
                    aggregatableReportWindow = input.nextNumber().intValue();
                    continue block32;
                }
                case "type": {
                    type = (AttributionReportingSourceType)((Object)input.read((Type)((Object)AttributionReportingSourceType.class)));
                    continue block32;
                }
                case "sourceOrigin": {
                    sourceOrigin = input.nextString();
                    continue block32;
                }
                case "reportingOrigin": {
                    reportingOrigin = input.nextString();
                    continue block32;
                }
                case "destinationSites": {
                    destinationSites = input.readArray((Type)((Object)String.class));
                    continue block32;
                }
                case "eventId": {
                    eventId = (UnsignedInt64AsBase10)input.read((Type)((Object)UnsignedInt64AsBase10.class));
                    continue block32;
                }
                case "priority": {
                    priority = (SignedInt64AsBase10)input.read((Type)((Object)SignedInt64AsBase10.class));
                    continue block32;
                }
                case "filterData": {
                    filterData = input.readArray((Type)((Object)AttributionReportingFilterDataEntry.class));
                    continue block32;
                }
                case "aggregationKeys": {
                    aggregationKeys = input.readArray((Type)((Object)AttributionReportingAggregationKeysEntry.class));
                    continue block32;
                }
                case "debugKey": {
                    debugKey = Optional.ofNullable((UnsignedInt64AsBase10)input.read((Type)((Object)UnsignedInt64AsBase10.class)));
                    continue block32;
                }
                case "triggerDataMatching": {
                    triggerDataMatching = (AttributionReportingTriggerDataMatching)((Object)input.read((Type)((Object)AttributionReportingTriggerDataMatching.class)));
                    continue block32;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new AttributionReportingSourceRegistration(time, expiry, triggerSpecs, aggregatableReportWindow, type, sourceOrigin, reportingOrigin, destinationSites, eventId, priority, filterData, aggregationKeys, debugKey, triggerDataMatching);
    }
}

