/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.edge;

import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebDriverInfo;
import org.openqa.selenium.chromium.ChromiumDriverInfo;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeDriverService;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.NoSuchDriverException;
import org.openqa.selenium.remote.service.DriverFinder;
import shaded.com.google.auto.service.AutoService;

@AutoService(value={WebDriverInfo.class})
public class EdgeDriverInfo
extends ChromiumDriverInfo {
    private static final Logger LOG = Logger.getLogger(EdgeDriverInfo.class.getName());

    @Override
    public String getDisplayName() {
        return "Edge";
    }

    @Override
    public Capabilities getCanonicalCapabilities() {
        return new ImmutableCapabilities("browserName", Browser.EDGE.browserName());
    }

    @Override
    public boolean isSupporting(Capabilities capabilities) {
        return Browser.EDGE.is(capabilities.getBrowserName()) || "webview2".equalsIgnoreCase(capabilities.getBrowserName()) || capabilities.getCapability("ms:edgeOptions") != null;
    }

    @Override
    public boolean isSupportingCdp() {
        return true;
    }

    @Override
    public boolean isSupportingBiDi() {
        return false;
    }

    @Override
    public boolean isAvailable() {
        try {
            DriverFinder.getPath(EdgeDriverService.createDefaultService(), this.getCanonicalCapabilities());
            return true;
        }
        catch (NoSuchDriverException e) {
            return false;
        }
        catch (IllegalStateException | WebDriverException e) {
            LOG.log(Level.WARNING, "failed to discover driver path", e);
            return false;
        }
    }

    @Override
    public boolean isPresent() {
        try {
            DriverFinder.getPath(EdgeDriverService.createDefaultService(), this.getCanonicalCapabilities(), true);
            return true;
        }
        catch (NoSuchDriverException e) {
            return false;
        }
        catch (IllegalStateException | WebDriverException e) {
            LOG.log(Level.WARNING, "failed to discover driver path", e);
            return false;
        }
    }

    @Override
    public Optional<WebDriver> createDriver(Capabilities capabilities) throws SessionNotCreatedException {
        if (!this.isAvailable() || !this.isSupporting(capabilities)) {
            return Optional.empty();
        }
        return Optional.of(new EdgeDriver(new EdgeOptions().merge(capabilities)));
    }
}

