/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import java.util.Map;
import java.util.function.Predicate;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.firefox.FirefoxCommandContext;
import org.openqa.selenium.firefox.HasContext;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.AdditionalHttpCommands;
import org.openqa.selenium.remote.AugmenterProvider;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.http.HttpMethod;
import shaded.com.google.auto.service.AutoService;

@AutoService(value={AdditionalHttpCommands.class, AugmenterProvider.class})
public class AddHasContext
implements AugmenterProvider<HasContext>,
AdditionalHttpCommands {
    public static final String SET_CONTEXT = "setContext";
    public static final String GET_CONTEXT = "getContext";
    private static final Map<String, CommandInfo> COMMANDS = Map.of("setContext", new CommandInfo("/session/:sessionId/moz/context", HttpMethod.POST), "getContext", new CommandInfo("/session/:sessionId/moz/context", HttpMethod.GET));

    @Override
    public Map<String, CommandInfo> getAdditionalCommands() {
        return COMMANDS;
    }

    @Override
    public Predicate<Capabilities> isApplicable() {
        return Browser.FIREFOX::is;
    }

    @Override
    public Class<HasContext> getDescribedInterface() {
        return HasContext.class;
    }

    @Override
    public HasContext getImplementation(Capabilities capabilities, final ExecuteMethod executeMethod) {
        return new HasContext(){

            @Override
            public void setContext(FirefoxCommandContext context) {
                Require.nonNull("Firefox Command Context", context);
                executeMethod.execute(AddHasContext.SET_CONTEXT, Map.of("context", context));
            }

            @Override
            public FirefoxCommandContext getContext() {
                String context = (String)executeMethod.execute(AddHasContext.GET_CONTEXT, null);
                return FirefoxCommandContext.fromString(context);
            }
        };
    }
}

