/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebDriverInfo;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.GeckoDriverService;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.NoSuchDriverException;
import org.openqa.selenium.remote.service.DriverFinder;
import shaded.com.google.auto.service.AutoService;

@AutoService(value={WebDriverInfo.class})
public class GeckoDriverInfo
implements WebDriverInfo {
    private static final Logger LOG = Logger.getLogger(GeckoDriverInfo.class.getName());

    @Override
    public String getDisplayName() {
        return "Firefox";
    }

    @Override
    public Capabilities getCanonicalCapabilities() {
        return new ImmutableCapabilities("browserName", Browser.FIREFOX.browserName());
    }

    @Override
    public boolean isSupporting(Capabilities capabilities) {
        if (Browser.FIREFOX.is(capabilities)) {
            return true;
        }
        return capabilities.asMap().keySet().stream().anyMatch(key -> key.startsWith("moz:"));
    }

    @Override
    public boolean isSupportingCdp() {
        return true;
    }

    @Override
    public boolean isSupportingBiDi() {
        return true;
    }

    @Override
    public boolean isAvailable() {
        try {
            DriverFinder.getPath(GeckoDriverService.createDefaultService(), this.getCanonicalCapabilities());
            return true;
        }
        catch (NoSuchDriverException e) {
            return false;
        }
        catch (IllegalStateException | WebDriverException e) {
            LOG.log(Level.WARNING, "failed to discover driver path", e);
            return false;
        }
    }

    @Override
    public boolean isPresent() {
        try {
            DriverFinder.getPath(GeckoDriverService.createDefaultService(), this.getCanonicalCapabilities(), true);
            return true;
        }
        catch (NoSuchDriverException e) {
            return false;
        }
        catch (IllegalStateException | WebDriverException e) {
            LOG.log(Level.WARNING, "failed to discover driver path", e);
            return false;
        }
    }

    @Override
    public int getMaximumSimultaneousSessions() {
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    public Optional<WebDriver> createDriver(Capabilities capabilities) throws SessionNotCreatedException {
        if (!this.isAvailable()) {
            return Optional.empty();
        }
        return Optional.of(new FirefoxDriver(new FirefoxOptions().merge(capabilities)));
    }
}

