/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.ie;

import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebDriverInfo;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerDriverService;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.NoSuchDriverException;
import org.openqa.selenium.remote.service.DriverFinder;
import shaded.com.google.auto.service.AutoService;

@AutoService(value={WebDriverInfo.class})
public class InternetExplorerDriverInfo
implements WebDriverInfo {
    private static final Logger LOG = Logger.getLogger(InternetExplorerDriverInfo.class.getName());

    @Override
    public String getDisplayName() {
        return "Internet Explorer";
    }

    @Override
    public Capabilities getCanonicalCapabilities() {
        return new ImmutableCapabilities("browserName", Browser.IE.browserName());
    }

    @Override
    public boolean isSupporting(Capabilities capabilities) {
        return Browser.IE.is(capabilities) || capabilities.getCapability("se:ieOptions") != null;
    }

    @Override
    public boolean isSupportingCdp() {
        return false;
    }

    @Override
    public boolean isSupportingBiDi() {
        return false;
    }

    @Override
    public boolean isAvailable() {
        try {
            if (Platform.getCurrent().is(Platform.WINDOWS)) {
                DriverFinder.getPath(InternetExplorerDriverService.createDefaultService(), this.getCanonicalCapabilities());
                return true;
            }
            return false;
        }
        catch (NoSuchDriverException e) {
            return false;
        }
        catch (IllegalStateException | WebDriverException e) {
            LOG.log(Level.WARNING, "failed to discover driver path", e);
            return false;
        }
    }

    @Override
    public boolean isPresent() {
        try {
            if (Platform.getCurrent().is(Platform.WINDOWS)) {
                DriverFinder.getPath(InternetExplorerDriverService.createDefaultService(), this.getCanonicalCapabilities(), true);
                return true;
            }
            return false;
        }
        catch (NoSuchDriverException e) {
            return false;
        }
        catch (IllegalStateException | WebDriverException e) {
            LOG.log(Level.WARNING, "failed to discover driver path", e);
            return false;
        }
    }

    @Override
    public int getMaximumSimultaneousSessions() {
        return 1;
    }

    @Override
    public Optional<WebDriver> createDriver(Capabilities capabilities) throws SessionNotCreatedException {
        if (!this.isAvailable()) {
            return Optional.empty();
        }
        return Optional.of(new InternetExplorerDriver(new InternetExplorerOptions().merge(capabilities)));
    }
}

