/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Stream;
import org.openqa.selenium.internal.Require;

public class Either<A, B>
implements Iterable<B> {
    private final A left;
    private final B right;

    private Either(A a, B b) {
        this.left = a;
        this.right = b;
    }

    public static <A, B> Either<A, B> left(A a) {
        return new Either<A, Object>(a, null);
    }

    public static <A, B> Either<A, B> right(B b) {
        return new Either<Object, B>(null, b);
    }

    public boolean isLeft() {
        return this.left != null;
    }

    public boolean isRight() {
        return this.right != null;
    }

    public A left() {
        return this.left;
    }

    public B right() {
        return this.right;
    }

    public <R> R map(Function<? super B, ? extends R> mapper) {
        Require.nonNull("Mapper", mapper);
        return mapper.apply(this.right());
    }

    public <R> R mapLeft(Function<? super A, ? extends R> mapper) {
        Require.nonNull("Mapper", mapper);
        return mapper.apply(this.left());
    }

    @Override
    public Iterator<B> iterator() {
        return Collections.singleton(this.right()).iterator();
    }

    public Stream<B> stream() {
        return Stream.of(this.right());
    }

    public String toString() {
        return "[Either(" + (this.isLeft() ? "left" : "right") + "): " + (this.isLeft() ? this.left() : this.right()) + "]";
    }
}

