/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.logging.LocalLogs;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.logging.NeedsLocalLogs;
import org.openqa.selenium.logging.profiler.HttpProfilerLogEntry;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandCodec;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.HttpSessionId;
import org.openqa.selenium.remote.ProtocolHandshake;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.ResponseCodec;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class HttpCommandExecutor
implements CommandExecutor,
NeedsLocalLogs {
    private final URL remoteServer;
    private final HttpClient client;
    private final HttpClient.Factory httpClientFactory;
    private final Map<String, CommandInfo> additionalCommands;
    private CommandCodec<HttpRequest> commandCodec;
    private ResponseCodec<HttpResponse> responseCodec;
    private LocalLogs logs = LocalLogs.getNullLogger();

    public static HttpClient.Factory getDefaultClientFactory() {
        return DefaultClientFactoryHolder.defaultClientFactory;
    }

    public HttpCommandExecutor(URL addressOfRemoteServer) {
        this(Collections.emptyMap(), Require.nonNull("Server URL", addressOfRemoteServer));
    }

    public HttpCommandExecutor(ClientConfig config) {
        this(Collections.emptyMap(), Require.nonNull("HTTP client configuration", config), HttpCommandExecutor.getDefaultClientFactory());
    }

    public HttpCommandExecutor(Map<String, CommandInfo> additionalCommands, URL addressOfRemoteServer) {
        this(Require.nonNull("Additional commands", additionalCommands), Require.nonNull("Server URL", addressOfRemoteServer), HttpCommandExecutor.getDefaultClientFactory());
    }

    public HttpCommandExecutor(Map<String, CommandInfo> additionalCommands, URL addressOfRemoteServer, ClientConfig config) {
        this(additionalCommands, config.baseUrl(Require.nonNull("Server URL", addressOfRemoteServer)), HttpCommandExecutor.getDefaultClientFactory());
    }

    public HttpCommandExecutor(Map<String, CommandInfo> additionalCommands, URL addressOfRemoteServer, HttpClient.Factory httpClientFactory) {
        this(additionalCommands, ClientConfig.defaultConfig().baseUrl(Require.nonNull("Server URL", addressOfRemoteServer)), httpClientFactory);
    }

    public HttpCommandExecutor(Map<String, CommandInfo> additionalCommands, ClientConfig config, HttpClient.Factory httpClientFactory) {
        this.remoteServer = Require.nonNull("HTTP client configuration", config).baseUrl();
        this.additionalCommands = Require.nonNull("Additional commands", additionalCommands);
        this.httpClientFactory = Require.nonNull("HTTP client factory", httpClientFactory);
        this.client = this.httpClientFactory.createClient(config);
    }

    protected void defineCommand(String commandName, CommandInfo info) {
        Require.nonNull("Command name", commandName);
        Require.nonNull("Command info", info);
        this.commandCodec.defineCommand(commandName, info.getMethod(), info.getUrl());
    }

    @Override
    public void setLocalLogs(LocalLogs logs) {
        this.logs = logs;
    }

    private void log(String logType, LogEntry entry) {
        this.logs.addEntry(logType, entry);
    }

    public URL getAddressOfRemoteServer() {
        return this.remoteServer;
    }

    @Override
    public Response execute(Command command) throws IOException {
        if (command.getSessionId() == null) {
            if ("quit".equals(command.getName())) {
                return new Response();
            }
            if (!"newSession".equals(command.getName())) {
                throw new NoSuchSessionException("Session ID is null. Using WebDriver after calling quit()?");
            }
        }
        if ("newSession".equals(command.getName())) {
            if (this.commandCodec != null) {
                throw new SessionNotCreatedException("Session already exists");
            }
            ProtocolHandshake handshake = new ProtocolHandshake();
            this.log("profiler", new HttpProfilerLogEntry(command.getName(), true));
            ProtocolHandshake.Result result = handshake.createSession((HttpHandler)this.client, command);
            Dialect dialect = result.getDialect();
            this.commandCodec = dialect.getCommandCodec();
            for (Map.Entry<String, CommandInfo> entry : this.additionalCommands.entrySet()) {
                this.defineCommand(entry.getKey(), entry.getValue());
            }
            this.responseCodec = dialect.getResponseCodec();
            this.log("profiler", new HttpProfilerLogEntry(command.getName(), false));
            return result.createResponse();
        }
        if (this.commandCodec == null || this.responseCodec == null) {
            throw new WebDriverException("No command or response codec has been defined. Unable to proceed");
        }
        HttpRequest httpRequest = this.commandCodec.encode(command);
        if (httpRequest.getHeader("Content-Type") == null) {
            httpRequest.addHeader("Content-Type", "application/json; charset=utf-8");
        }
        try {
            this.log("profiler", new HttpProfilerLogEntry(command.getName(), true));
            HttpResponse httpResponse = this.client.execute(httpRequest);
            this.log("profiler", new HttpProfilerLogEntry(command.getName(), false));
            Response response = this.responseCodec.decode(httpResponse);
            if (response.getSessionId() == null) {
                if (httpResponse.getTargetHost() != null) {
                    response.setSessionId(HttpSessionId.getSessionId(httpResponse.getTargetHost()).orElse(null));
                } else {
                    response.setSessionId(command.getSessionId().toString());
                }
            }
            if ("quit".equals(command.getName())) {
                this.client.close();
                this.httpClientFactory.cleanupIdleClients();
            }
            return response;
        }
        catch (UnsupportedCommandException e) {
            if (e.getMessage() == null || "".equals(e.getMessage())) {
                throw new UnsupportedOperationException("No information from server. Command name was: " + command.getName(), e.getCause());
            }
            throw e;
        }
    }

    private static class DefaultClientFactoryHolder {
        static HttpClient.Factory defaultClientFactory = HttpClient.Factory.createDefault();

        private DefaultClientFactoryHolder() {
        }
    }
}

