/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.codec;

import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.remote.ErrorCodes;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.ResponseCodec;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHeader;
import org.openqa.selenium.remote.http.HttpResponse;

public abstract class AbstractHttpResponseCodec
implements ResponseCodec<HttpResponse> {
    private final ErrorCodes errorCodes = new ErrorCodes();
    private final Json json = new Json();

    @Override
    public HttpResponse encode(Supplier<HttpResponse> factory, Response response) {
        int status = response.getStatus() == 0 ? 200 : 500;
        byte[] data = this.json.toJson(this.getValueToEncode(response)).getBytes(StandardCharsets.UTF_8);
        HttpResponse httpResponse = factory.get();
        httpResponse.setStatus(status);
        httpResponse.setHeader(HttpHeader.CacheControl.getName(), "no-cache");
        httpResponse.setHeader(HttpHeader.Expires.getName(), "Thu, 01 Jan 1970 00:00:00 GMT");
        httpResponse.setHeader(HttpHeader.ContentLength.getName(), String.valueOf(data.length));
        httpResponse.setHeader(HttpHeader.ContentType.getName(), "application/json; charset=utf-8");
        httpResponse.setContent((Supplier)Contents.bytes(data));
        return httpResponse;
    }

    protected abstract Object getValueToEncode(Response var1);

    @Override
    public Response decode(HttpResponse encodedResponse) {
        String content;
        block18: {
            String contentType = Objects.requireNonNullElse(encodedResponse.getHeader(HttpHeader.ContentType.getName()), "");
            content = Contents.string(encodedResponse).trim();
            try {
                return this.reconstructValue((Response)this.json.toType(content, (Type)((Object)Response.class)));
            }
            catch (JsonException e) {
                if (contentType.startsWith("application/json")) {
                    throw new IllegalArgumentException("Cannot decode response content: " + content, e);
                }
            }
            catch (ClassCastException e) {
                if (!contentType.startsWith("application/json")) break block18;
                if (content.isEmpty()) {
                    return new Response();
                }
                throw new IllegalArgumentException("Cannot decode response content: " + content, e);
            }
        }
        Response response = new Response();
        int statusCode = encodedResponse.getStatus();
        if (statusCode < 200 || statusCode > 299) {
            if (statusCode > 399 && statusCode < 500) {
                response.setStatus(9);
            } else {
                response.setStatus(13);
            }
        }
        if (!content.isEmpty()) {
            response.setValue(content);
        }
        if (response.getValue() instanceof String) {
            response.setValue(((String)response.getValue()).replace("\r\n", "\n"));
        }
        if (response.getStatus() != null && response.getState() == null) {
            response.setState(this.errorCodes.toState(response.getStatus()));
        } else if (response.getStatus() == null && response.getState() != null) {
            response.setStatus(this.errorCodes.toStatus(response.getState(), Optional.of(encodedResponse.getStatus())));
        } else if (statusCode == 200) {
            response.setStatus(0);
            response.setState(this.errorCodes.toState(0));
        }
        if (response.getStatus() != null) {
            response.setState(this.errorCodes.toState(response.getStatus()));
        } else if (statusCode == 200) {
            response.setState(this.errorCodes.toState(0));
        }
        return response;
    }

    protected abstract Response reconstructValue(Response var1);
}

