/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.AdditionalHttpCommands;
import org.openqa.selenium.remote.AugmenterProvider;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.safari.HasPermissions;
import shaded.com.google.auto.service.AutoService;

@AutoService(value={AdditionalHttpCommands.class, AugmenterProvider.class})
public class AddHasPermissions
implements AugmenterProvider<HasPermissions>,
AdditionalHttpCommands {
    public static final String GET_PERMISSIONS = "getPermissions";
    public static final String SET_PERMISSIONS = "setPermissions";
    private static final Map<String, CommandInfo> COMMANDS = Map.of("getPermissions", new CommandInfo("/session/:sessionId/apple/permissions", HttpMethod.GET), "setPermissions", new CommandInfo("/session/:sessionId/apple/permissions", HttpMethod.POST));

    @Override
    public Map<String, CommandInfo> getAdditionalCommands() {
        return COMMANDS;
    }

    @Override
    public Predicate<Capabilities> isApplicable() {
        return caps -> "Safari".equals(caps.getBrowserName());
    }

    @Override
    public Class<HasPermissions> getDescribedInterface() {
        return HasPermissions.class;
    }

    @Override
    public HasPermissions getImplementation(Capabilities capabilities, final ExecuteMethod executeMethod) {
        return new HasPermissions(){

            @Override
            public void setPermissions(String permission, boolean value) {
                executeMethod.execute(AddHasPermissions.SET_PERMISSIONS, Map.of("permissions", Map.of(permission, value)));
            }

            @Override
            public Map<String, Boolean> getPermissions() {
                Object resultObject = executeMethod.execute(AddHasPermissions.GET_PERMISSIONS, null);
                if (resultObject instanceof Map) {
                    Map resultMap = (Map)resultObject;
                    HashMap<String, Boolean> permissionMap = new HashMap<String, Boolean>();
                    for (Map.Entry entry : resultMap.entrySet()) {
                        if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof Boolean)) continue;
                        permissionMap.put((String)entry.getKey(), (Boolean)entry.getValue());
                    }
                    return permissionMap;
                }
                throw new IllegalStateException("Unexpected result type: " + resultObject.getClass().getName());
            }
        };
    }
}

