/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.javalib.factory;

import java.util.List;
import java.util.Map;
import org.robotframework.javalib.beans.annotation.KeywordBeanLoader;
import org.robotframework.javalib.beans.classpath.InterfaceBasedKeywordFilter;
import org.robotframework.javalib.factory.KeywordFactory;
import org.robotframework.javalib.keyword.Keyword;
import org.robotframework.javalib.keyword.KeywordMap;

public class ClassPathKeywordFactory
implements KeywordFactory<Keyword> {
    private KeywordMap map = new KeywordMap();

    public ClassPathKeywordFactory(KeywordBeanLoader loader) {
        Map kws = loader.loadBeanDefinitions(new InterfaceBasedKeywordFilter());
        this.remapNames(kws);
    }

    private void remapNames(Map<String, Object> kws) {
        for (String key : kws.keySet()) {
            String lastPart = this.getKwName(key);
            this.map.add(lastPart, kws.get(key));
        }
    }

    private String getKwName(String name) {
        if (!name.contains("/")) {
            return name;
        }
        return name.substring(name.lastIndexOf(47) + 1);
    }

    @Override
    public Keyword createKeyword(String keywordName) {
        return (Keyword)this.map.get(keywordName);
    }

    @Override
    public List<String> getKeywordNames() {
        return this.map.getKeywordNames();
    }
}

