/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.jcache.interceptor;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractBeanFactoryPointcutAdvisor;
import org.springframework.aop.support.StaticMethodMatcherPointcut;
import org.springframework.cache.jcache.interceptor.JCacheOperationSource;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

public class BeanFactoryJCacheOperationSourceAdvisor
extends AbstractBeanFactoryPointcutAdvisor {
    private final JCacheOperationSourcePointcut pointcut = new JCacheOperationSourcePointcut();

    public void setCacheOperationSource(JCacheOperationSource cacheOperationSource) {
        this.pointcut.setCacheOperationSource(cacheOperationSource);
    }

    public void setClassFilter(ClassFilter classFilter) {
        this.pointcut.setClassFilter(classFilter);
    }

    @Override
    public Pointcut getPointcut() {
        return this.pointcut;
    }

    private static class JCacheOperationSourcePointcut
    extends StaticMethodMatcherPointcut
    implements Serializable {
        @Nullable
        private JCacheOperationSource cacheOperationSource;

        private JCacheOperationSourcePointcut() {
        }

        public void setCacheOperationSource(@Nullable JCacheOperationSource cacheOperationSource) {
            this.cacheOperationSource = cacheOperationSource;
        }

        @Override
        public boolean matches(Method method, Class<?> targetClass) {
            return this.cacheOperationSource == null || this.cacheOperationSource.getCacheOperation(method, targetClass) != null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(@Nullable Object other) {
            if (this == other) return true;
            if (!(other instanceof JCacheOperationSourcePointcut)) return false;
            JCacheOperationSourcePointcut that = (JCacheOperationSourcePointcut)other;
            if (!ObjectUtils.nullSafeEquals(this.cacheOperationSource, that.cacheOperationSource)) return false;
            return true;
        }

        public int hashCode() {
            return JCacheOperationSourcePointcut.class.hashCode();
        }

        public String toString() {
            return this.getClass().getName() + ": " + this.cacheOperationSource;
        }
    }
}

