/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.codec;

import java.util.Map;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.AbstractDataBufferDecoder;
import org.springframework.core.codec.Hints;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.NettyDataBuffer;
import org.springframework.lang.Nullable;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import shaded.io.netty.buffer.ByteBuf;
import shaded.io.netty.buffer.Unpooled;

public class NettyByteBufDecoder
extends AbstractDataBufferDecoder<ByteBuf> {
    public NettyByteBufDecoder() {
        super(MimeTypeUtils.ALL);
    }

    @Override
    public boolean canDecode(ResolvableType elementType, @Nullable MimeType mimeType) {
        return ByteBuf.class.isAssignableFrom(elementType.toClass()) && super.canDecode(elementType, mimeType);
    }

    @Override
    public ByteBuf decode(DataBuffer dataBuffer, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Hints.getLogPrefix(hints) + "Read " + dataBuffer.readableByteCount() + " bytes");
        }
        if (dataBuffer instanceof NettyDataBuffer) {
            NettyDataBuffer nettyDataBuffer = (NettyDataBuffer)dataBuffer;
            return nettyDataBuffer.getNativeBuffer();
        }
        byte[] bytes = new byte[dataBuffer.readableByteCount()];
        dataBuffer.read(bytes);
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])bytes);
        DataBufferUtils.release(dataBuffer);
        return byteBuf;
    }
}

