/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.google.inject.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import shaded.com.google.common.collect.ImmutableSet;
import shaded.com.google.inject.internal.ConstructionContext;
import shaded.com.google.inject.internal.ConstructionProxy;
import shaded.com.google.inject.internal.Errors;
import shaded.com.google.inject.internal.ErrorsException;
import shaded.com.google.inject.internal.InternalContext;
import shaded.com.google.inject.internal.MembersInjectorImpl;
import shaded.com.google.inject.internal.ProvisionListenerStackCallback;
import shaded.com.google.inject.internal.SingleParameterInjector;
import shaded.com.google.inject.spi.InjectionPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ConstructorInjector<T> {
    private final ImmutableSet<InjectionPoint> injectableMembers;
    private final SingleParameterInjector<?>[] parameterInjectors;
    private final ConstructionProxy<T> constructionProxy;
    private final MembersInjectorImpl<T> membersInjector;

    ConstructorInjector(Set<InjectionPoint> injectableMembers, ConstructionProxy<T> constructionProxy, SingleParameterInjector<?>[] parameterInjectors, MembersInjectorImpl<T> membersInjector) {
        this.injectableMembers = ImmutableSet.copyOf(injectableMembers);
        this.constructionProxy = constructionProxy;
        this.parameterInjectors = parameterInjectors;
        this.membersInjector = membersInjector;
    }

    public ImmutableSet<InjectionPoint> getInjectableMembers() {
        return this.injectableMembers;
    }

    ConstructionProxy<T> getConstructionProxy() {
        return this.constructionProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object construct(final Errors errors, final InternalContext context, Class<?> expectedType, boolean allowProxy, ProvisionListenerStackCallback<T> provisionCallback) throws ErrorsException {
        final ConstructionContext constructionContext = context.getConstructionContext(this);
        if (constructionContext.isConstructing()) {
            if (!allowProxy) {
                throw errors.circularProxiesDisabled(expectedType).toException();
            }
            return constructionContext.createProxy(errors, expectedType);
        }
        Object t2 = constructionContext.getCurrentReference();
        if (t2 != null) {
            return t2;
        }
        try {
            if (!provisionCallback.hasListeners()) {
                Object t3 = this.provision(errors, context, constructionContext);
                return t3;
            }
            T t4 = provisionCallback.provision(errors, context, new ProvisionListenerStackCallback.ProvisionCallback<T>(){

                @Override
                public T call() throws ErrorsException {
                    return ConstructorInjector.this.provision(errors, context, constructionContext);
                }
            });
            return t4;
        }
        finally {
            constructionContext.removeCurrentReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T provision(Errors errors, InternalContext context, ConstructionContext<T> constructionContext) throws ErrorsException {
        try {
            T t2;
            constructionContext.startConstruction();
            try {
                Object[] parameters = SingleParameterInjector.getAll(errors, context, this.parameterInjectors);
                t2 = this.constructionProxy.newInstance(parameters);
                constructionContext.setProxyDelegates(t2);
            }
            finally {
                constructionContext.finishConstruction();
            }
            constructionContext.setCurrentReference(t2);
            this.membersInjector.injectMembers(t2, errors, context, false);
            this.membersInjector.notifyListeners(t2, errors);
            return t2;
        }
        catch (InvocationTargetException userException) {
            Throwable cause = userException.getCause() != null ? userException.getCause() : userException;
            throw errors.withSource(this.constructionProxy.getInjectionPoint()).errorInjectingConstructor(cause).toException();
        }
    }
}

