/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.google.inject.internal;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import shaded.com.google.common.base.Preconditions;
import shaded.com.google.common.collect.Lists;
import shaded.com.google.common.collect.Maps;
import shaded.com.google.inject.Key;
import shaded.com.google.inject.Stage;
import shaded.com.google.inject.TypeLiteral;
import shaded.com.google.inject.internal.Errors;
import shaded.com.google.inject.internal.ErrorsException;
import shaded.com.google.inject.internal.Initializable;
import shaded.com.google.inject.internal.Initializables;
import shaded.com.google.inject.internal.InjectorImpl;
import shaded.com.google.inject.internal.MembersInjectorImpl;
import shaded.com.google.inject.spi.InjectionPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Initializer {
    private final Thread creatingThread = Thread.currentThread();
    private final CountDownLatch ready = new CountDownLatch(1);
    private final Map<Object, InjectableReference<?>> pendingInjection = Maps.newIdentityHashMap();

    Initializer() {
    }

    <T> Initializable<T> requestInjection(InjectorImpl injector, T instance, Key<T> key, Object source, Set<InjectionPoint> injectionPoints) {
        Preconditions.checkNotNull(source);
        if (instance == null || injectionPoints.isEmpty() && !injector.membersInjectorStore.hasTypeListeners()) {
            return Initializables.of(instance);
        }
        InjectableReference<T> initializable = new InjectableReference<T>(injector, instance, key, source);
        this.pendingInjection.put(instance, initializable);
        return initializable;
    }

    void validateOustandingInjections(Errors errors) {
        for (InjectableReference<?> reference : this.pendingInjection.values()) {
            try {
                reference.validate(errors);
            }
            catch (ErrorsException e) {
                errors.merge(e.getErrors());
            }
        }
    }

    void injectAll(Errors errors) {
        for (InjectableReference<?> reference : Lists.newArrayList(this.pendingInjection.values())) {
            try {
                reference.get(errors);
            }
            catch (ErrorsException e) {
                errors.merge(e.getErrors());
            }
        }
        if (!this.pendingInjection.isEmpty()) {
            throw new AssertionError((Object)("Failed to satisfy " + this.pendingInjection));
        }
        this.ready.countDown();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InjectableReference<T>
    implements Initializable<T> {
        private final InjectorImpl injector;
        private final T instance;
        private final Object source;
        private final Key<T> key;
        private MembersInjectorImpl<T> membersInjector;

        public InjectableReference(InjectorImpl injector, T instance, Key<T> key, Object source) {
            this.injector = injector;
            this.key = key;
            this.instance = Preconditions.checkNotNull(instance, "instance");
            this.source = Preconditions.checkNotNull(source, "source");
        }

        public void validate(Errors errors) throws ErrorsException {
            TypeLiteral<?> type = TypeLiteral.get(this.instance.getClass());
            this.membersInjector = this.injector.membersInjectorStore.get(type, errors.withSource(this.source));
        }

        @Override
        public T get(Errors errors) throws ErrorsException {
            if (Initializer.this.ready.getCount() == 0L) {
                return this.instance;
            }
            if (Thread.currentThread() != Initializer.this.creatingThread) {
                try {
                    Initializer.this.ready.await();
                    return this.instance;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            if (Initializer.this.pendingInjection.remove(this.instance) != null) {
                this.membersInjector.injectAndNotify(this.instance, errors.withSource(this.source), this.key, this.source, this.injector.options.stage == Stage.TOOL);
            }
            return this.instance;
        }

        public String toString() {
            return this.instance.toString();
        }
    }
}

