/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.google.inject.internal;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.collect.Maps;
import shaded.com.google.inject.Key;
import shaded.com.google.inject.internal.ConstructionContext;
import shaded.com.google.inject.spi.Dependency;
import shaded.com.google.inject.spi.DependencyAndSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InternalContext {
    private Map<Object, ConstructionContext<?>> constructionContexts = Maps.newHashMap();
    private Dependency dependency;
    private LinkedList<DependencyAndSource> state = new LinkedList();

    InternalContext() {
    }

    public <T> ConstructionContext<T> getConstructionContext(Object key) {
        ConstructionContext<Object> constructionContext = this.constructionContexts.get(key);
        if (constructionContext == null) {
            constructionContext = new ConstructionContext();
            this.constructionContexts.put(key, constructionContext);
        }
        return constructionContext;
    }

    public Dependency getDependency() {
        return this.dependency;
    }

    public Dependency pushDependency(Dependency dependency, Object source) {
        Dependency previous = this.dependency;
        this.dependency = dependency;
        this.state.addLast(new DependencyAndSource(dependency, source));
        return previous;
    }

    public void popStateAndSetDependency(Dependency newDependency) {
        this.popState();
        this.dependency = newDependency;
    }

    public void pushState(Key<?> key, Object source) {
        this.state.addLast(new DependencyAndSource(key == null ? null : Dependency.get(key), source));
    }

    public void popState() {
        this.state.removeLast();
    }

    public List<DependencyAndSource> getDependencyChain() {
        return ImmutableList.copyOf(this.state);
    }
}

