/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.google.inject.internal;

import shaded.com.google.common.base.Preconditions;
import shaded.com.google.inject.Provider;
import shaded.com.google.inject.internal.ConstructionContext;
import shaded.com.google.inject.internal.Errors;
import shaded.com.google.inject.internal.ErrorsException;
import shaded.com.google.inject.internal.Initializable;
import shaded.com.google.inject.internal.InternalContext;
import shaded.com.google.inject.internal.ProviderInternalFactory;
import shaded.com.google.inject.internal.ProvisionListenerStackCallback;
import shaded.com.google.inject.spi.Dependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InternalFactoryToInitializableAdapter<T>
extends ProviderInternalFactory<T> {
    private final Initializable<Provider<? extends T>> initializable;

    public InternalFactoryToInitializableAdapter(Initializable<Provider<? extends T>> initializable, Object source, boolean allowProxy, ProvisionListenerStackCallback<T> provisionCallback) {
        super(source, allowProxy, provisionCallback);
        this.initializable = Preconditions.checkNotNull(initializable, "provider");
    }

    @Override
    public T get(Errors errors, InternalContext context, Dependency<?> dependency, boolean linked) throws ErrorsException {
        return this.circularGet((javax.inject.Provider)this.initializable.get(errors), errors, context, dependency, linked);
    }

    @Override
    protected T provision(javax.inject.Provider<? extends T> provider, Errors errors, Dependency<?> dependency, ConstructionContext<T> constructionContext) throws ErrorsException {
        try {
            return super.provision(provider, errors, dependency, constructionContext);
        }
        catch (RuntimeException userException) {
            throw errors.withSource(this.source).errorInProvider(userException).toException();
        }
    }

    public String toString() {
        return this.initializable.toString();
    }
}

