/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.google.inject.internal;

import javax.inject.Provider;
import shaded.com.google.common.base.Preconditions;
import shaded.com.google.inject.internal.ConstructionContext;
import shaded.com.google.inject.internal.Errors;
import shaded.com.google.inject.internal.ErrorsException;
import shaded.com.google.inject.internal.InternalContext;
import shaded.com.google.inject.internal.InternalFactory;
import shaded.com.google.inject.internal.ProvisionListenerStackCallback;
import shaded.com.google.inject.spi.Dependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ProviderInternalFactory<T>
implements InternalFactory<T> {
    private final ProvisionListenerStackCallback<T> provisionCallback;
    private final boolean allowProxy;
    protected final Object source;

    ProviderInternalFactory(Object source, boolean allowProxy, ProvisionListenerStackCallback<T> provisionCallback) {
        this.provisionCallback = Preconditions.checkNotNull(provisionCallback, "provisionCallback");
        this.source = Preconditions.checkNotNull(source, "source");
        this.allowProxy = allowProxy;
    }

    protected T circularGet(final Provider<? extends T> provider, final Errors errors, InternalContext context, final Dependency<?> dependency, boolean linked) throws ErrorsException {
        Class<?> expectedType = dependency.getKey().getTypeLiteral().getRawType();
        final ConstructionContext constructionContext = context.getConstructionContext(this);
        if (constructionContext.isConstructing()) {
            if (!this.allowProxy) {
                throw errors.circularProxiesDisabled(expectedType).toException();
            }
            Object proxyType = constructionContext.createProxy(errors, expectedType);
            return (T)proxyType;
        }
        if (!this.provisionCallback.hasListeners()) {
            return this.provision(provider, errors, dependency, constructionContext);
        }
        return this.provisionCallback.provision(errors, context, new ProvisionListenerStackCallback.ProvisionCallback<T>(){

            @Override
            public T call() throws ErrorsException {
                return ProviderInternalFactory.this.provision(provider, errors, dependency, constructionContext);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T provision(Provider<? extends T> provider, Errors errors, Dependency<?> dependency, ConstructionContext<T> constructionContext) throws ErrorsException {
        constructionContext.startConstruction();
        try {
            T t2 = errors.checkForNull(provider.get(), this.source, dependency);
            constructionContext.setProxyDelegates(t2);
            T t3 = t2;
            return t3;
        }
        finally {
            constructionContext.finishConstruction();
        }
    }
}

