/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.google.inject.internal;

import java.util.List;
import shaded.com.google.inject.Key;
import shaded.com.google.inject.ProvisionException;
import shaded.com.google.inject.internal.Errors;
import shaded.com.google.inject.internal.ErrorsException;
import shaded.com.google.inject.internal.InternalContext;
import shaded.com.google.inject.spi.DependencyAndSource;
import shaded.com.google.inject.spi.ProvisionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProvisionListenerStackCallback<T> {
    private static final ProvisionListener[] EMPTY_LISTENER = new ProvisionListener[0];
    private final ProvisionListener[] listeners;
    private final Key<T> key;

    public ProvisionListenerStackCallback(Key<T> key, List<ProvisionListener> listeners) {
        this.key = key;
        this.listeners = listeners.isEmpty() ? EMPTY_LISTENER : listeners.toArray(new ProvisionListener[listeners.size()]);
    }

    public boolean hasListeners() {
        return this.listeners.length > 0;
    }

    public T provision(Errors errors, InternalContext context, ProvisionCallback<T> callable) throws ErrorsException {
        Provision provision = new Provision(errors, context, callable);
        RuntimeException caught = null;
        try {
            provision.provision();
        }
        catch (RuntimeException t2) {
            caught = t2;
        }
        if (provision.exceptionDuringProvision != null) {
            throw provision.exceptionDuringProvision;
        }
        if (caught != null) {
            String listener = provision.erredListener != null ? provision.erredListener.getClass() : "(unknown)";
            throw errors.errorInUserCode(caught, "Error notifying ProvisionListener %s of %s.%n Reason: %s", listener, this.key, caught).toException();
        }
        return provision.result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Provision
    extends ProvisionListener.ProvisionInvocation<T> {
        final Errors errors;
        final InternalContext context;
        final ProvisionCallback<T> callable;
        int index = -1;
        T result;
        ErrorsException exceptionDuringProvision;
        ProvisionListener erredListener;

        public Provision(Errors errors, InternalContext context, ProvisionCallback<T> callable) {
            this.callable = callable;
            this.context = context;
            this.errors = errors;
        }

        @Override
        public T provision() {
            ++this.index;
            if (this.index == ProvisionListenerStackCallback.this.listeners.length) {
                try {
                    this.result = this.callable.call();
                }
                catch (ErrorsException ee) {
                    this.exceptionDuringProvision = ee;
                    throw new ProvisionException(this.errors.merge(ee.getErrors()).getMessages());
                }
            }
            if (this.index < ProvisionListenerStackCallback.this.listeners.length) {
                int currentIdx = this.index;
                try {
                    ProvisionListenerStackCallback.this.listeners[this.index].onProvision(this);
                }
                catch (RuntimeException re) {
                    this.erredListener = ProvisionListenerStackCallback.this.listeners[currentIdx];
                    throw re;
                }
                if (currentIdx == this.index) {
                    this.provision();
                }
            } else {
                throw new IllegalStateException("Already provisioned in this listener.");
            }
            return this.result;
        }

        @Override
        public Key<T> getKey() {
            return ProvisionListenerStackCallback.this.key;
        }

        @Override
        public List<DependencyAndSource> getDependencyChain() {
            return this.context.getDependencyChain();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ProvisionCallback<T> {
        public T call() throws ErrorsException;
    }
}

