/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.google.inject.internal;

import java.lang.reflect.Field;
import shaded.com.google.inject.internal.BindingImpl;
import shaded.com.google.inject.internal.Errors;
import shaded.com.google.inject.internal.ErrorsException;
import shaded.com.google.inject.internal.InjectorImpl;
import shaded.com.google.inject.internal.InternalContext;
import shaded.com.google.inject.internal.SingleMemberInjector;
import shaded.com.google.inject.spi.Dependency;
import shaded.com.google.inject.spi.InjectionPoint;

final class SingleFieldInjector
implements SingleMemberInjector {
    final Field field;
    final InjectionPoint injectionPoint;
    final Dependency<?> dependency;
    final BindingImpl<?> binding;

    public SingleFieldInjector(InjectorImpl injector, InjectionPoint injectionPoint, Errors errors) throws ErrorsException {
        this.injectionPoint = injectionPoint;
        this.field = (Field)injectionPoint.getMember();
        this.dependency = injectionPoint.getDependencies().get(0);
        this.field.setAccessible(true);
        this.binding = injector.getBindingOrThrow(this.dependency.getKey(), errors, InjectorImpl.JitLimitation.NO_JIT);
    }

    public InjectionPoint getInjectionPoint() {
        return this.injectionPoint;
    }

    public void inject(Errors errors, InternalContext context, Object o) {
        errors = errors.withSource(this.dependency);
        Dependency previous = context.pushDependency(this.dependency, this.binding.getSource());
        try {
            Object value = this.binding.getInternalFactory().get(errors, context, this.dependency, false);
            this.field.set(o, value);
        }
        catch (ErrorsException e) {
            errors.withSource(this.injectionPoint).merge(e.getErrors());
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            context.popStateAndSetDependency(previous);
        }
    }
}

