/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.google.inject.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import shaded.com.google.inject.TypeLiteral;
import shaded.com.google.inject.internal.AbstractProcessor;
import shaded.com.google.inject.internal.Errors;
import shaded.com.google.inject.internal.InjectorImpl;
import shaded.com.google.inject.internal.util.SourceProvider;
import shaded.com.google.inject.matcher.AbstractMatcher;
import shaded.com.google.inject.matcher.Matcher;
import shaded.com.google.inject.matcher.Matchers;
import shaded.com.google.inject.spi.TypeConverter;
import shaded.com.google.inject.spi.TypeConverterBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TypeConverterBindingProcessor
extends AbstractProcessor {
    TypeConverterBindingProcessor(Errors errors) {
        super(errors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepareBuiltInConverters(InjectorImpl injector) {
        this.injector = injector;
        try {
            this.convertToPrimitiveType(Integer.TYPE, Integer.class);
            this.convertToPrimitiveType(Long.TYPE, Long.class);
            this.convertToPrimitiveType(Boolean.TYPE, Boolean.class);
            this.convertToPrimitiveType(Byte.TYPE, Byte.class);
            this.convertToPrimitiveType(Short.TYPE, Short.class);
            this.convertToPrimitiveType(Float.TYPE, Float.class);
            this.convertToPrimitiveType(Double.TYPE, Double.class);
            this.convertToClass(Character.class, new TypeConverter(){

                @Override
                public Object convert(String value, TypeLiteral<?> toType) {
                    if ((value = value.trim()).length() != 1) {
                        throw new RuntimeException("Length != 1.");
                    }
                    return Character.valueOf(value.charAt(0));
                }

                public String toString() {
                    return "TypeConverter<Character>";
                }
            });
            this.convertToClasses(Matchers.subclassesOf(Enum.class), new TypeConverter(){

                @Override
                public Object convert(String value, TypeLiteral<?> toType) {
                    return Enum.valueOf(toType.getRawType(), value);
                }

                public String toString() {
                    return "TypeConverter<E extends Enum<E>>";
                }
            });
            this.internalConvertToTypes(new AbstractMatcher<TypeLiteral<?>>(){

                @Override
                public boolean matches(TypeLiteral<?> typeLiteral) {
                    return typeLiteral.getRawType() == Class.class;
                }

                public String toString() {
                    return "Class<?>";
                }
            }, new TypeConverter(){

                @Override
                public Object convert(String value, TypeLiteral<?> toType) {
                    try {
                        return Class.forName(value);
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e.getMessage());
                    }
                }

                public String toString() {
                    return "TypeConverter<Class<?>>";
                }
            });
        }
        finally {
            this.injector = null;
        }
    }

    private <T> void convertToPrimitiveType(Class<T> primitiveType, final Class<T> wrapperType) {
        try {
            final Method parser = wrapperType.getMethod("parse" + TypeConverterBindingProcessor.capitalize(primitiveType.getName()), String.class);
            TypeConverter typeConverter = new TypeConverter(){

                @Override
                public Object convert(String value, TypeLiteral<?> toType) {
                    try {
                        return parser.invoke(null, value);
                    }
                    catch (IllegalAccessException e) {
                        throw new AssertionError((Object)e);
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException(e.getTargetException().getMessage());
                    }
                }

                public String toString() {
                    return "TypeConverter<" + wrapperType.getSimpleName() + ">";
                }
            };
            this.convertToClass(wrapperType, typeConverter);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    private <T> void convertToClass(Class<T> type, TypeConverter converter) {
        this.convertToClasses(Matchers.identicalTo(type), converter);
    }

    private void convertToClasses(final Matcher<? super Class<?>> typeMatcher, TypeConverter converter) {
        this.internalConvertToTypes(new AbstractMatcher<TypeLiteral<?>>(){

            @Override
            public boolean matches(TypeLiteral<?> typeLiteral) {
                Type type = typeLiteral.getType();
                if (!(type instanceof Class)) {
                    return false;
                }
                Class clazz = (Class)type;
                return typeMatcher.matches(clazz);
            }

            public String toString() {
                return typeMatcher.toString();
            }
        }, converter);
    }

    private void internalConvertToTypes(Matcher<? super TypeLiteral<?>> typeMatcher, TypeConverter converter) {
        this.injector.state.addConverter(new TypeConverterBinding(SourceProvider.UNKNOWN_SOURCE, typeMatcher, converter));
    }

    @Override
    public Boolean visit(TypeConverterBinding command) {
        this.injector.state.addConverter(new TypeConverterBinding(command.getSource(), command.getTypeMatcher(), command.getTypeConverter()));
        return true;
    }

    private static String capitalize(String s2) {
        char capitalized;
        if (s2.length() == 0) {
            return s2;
        }
        char first = s2.charAt(0);
        return first == (capitalized = Character.toUpperCase(first)) ? s2 : capitalized + s2.substring(1);
    }
}

