/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.google.inject.internal.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import shaded.com.google.inject.internal.util.Classes;
import shaded.com.google.inject.internal.util.SourceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackTraceElements {
    public static Object forMember(Member member) {
        if (member == null) {
            return SourceProvider.UNKNOWN_SOURCE;
        }
        Class<?> declaringClass = member.getDeclaringClass();
        String fileName = null;
        int lineNumber = -1;
        Class<? extends Member> memberType = Classes.memberType(member);
        String memberName = memberType == Constructor.class ? "<init>" : member.getName();
        return new StackTraceElement(declaringClass.getName(), memberName, fileName, lineNumber);
    }

    public static Object forType(Class<?> implementation) {
        String fileName = null;
        int lineNumber = -1;
        return new StackTraceElement(implementation.getName(), "class", fileName, lineNumber);
    }
}

