/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.google.inject.spi;

import java.util.List;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.inject.Binder;
import shaded.com.google.inject.Key;
import shaded.com.google.inject.matcher.Matcher;
import shaded.com.google.inject.spi.Element;
import shaded.com.google.inject.spi.ElementVisitor;
import shaded.com.google.inject.spi.ProvisionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProvisionListenerBinding
implements Element {
    private final Object source;
    private final Matcher<? super Key<?>> keyMatcher;
    private final List<ProvisionListener> listeners;

    ProvisionListenerBinding(Object source, Matcher<? super Key<?>> typeMatcher, ProvisionListener[] listeners) {
        this.source = source;
        this.keyMatcher = typeMatcher;
        this.listeners = ImmutableList.copyOf(listeners);
    }

    public List<ProvisionListener> getListeners() {
        return this.listeners;
    }

    public Matcher<? super Key<?>> getKeyMatcher() {
        return this.keyMatcher;
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public <R> R acceptVisitor(ElementVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void applyTo(Binder binder) {
        binder.withSource(this.getSource()).bindListener(this.keyMatcher, this.listeners.toArray(new ProvisionListener[this.listeners.size()]));
    }
}

