/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.googlecode.javaewah;

import shaded.com.googlecode.javaewah.Buffer;
import shaded.com.googlecode.javaewah.ChunkIterator;
import shaded.com.googlecode.javaewah.EWAHIterator;
import shaded.com.googlecode.javaewah.RunningLengthWord;

final class ChunkIteratorImpl
implements ChunkIterator {
    private final EWAHIterator ewahIter;
    private final int sizeInBits;
    private final Buffer buffer;
    private int position;
    private boolean runningBit;
    private int runningLength;
    private long word;
    private long wordMask;
    private int wordPosition;
    private int wordLength;
    private boolean hasNext;
    private Boolean nextBit;
    private int nextLength;

    ChunkIteratorImpl(EWAHIterator ewahIter, int sizeInBits) {
        this.ewahIter = ewahIter;
        this.sizeInBits = sizeInBits;
        this.buffer = ewahIter.buffer();
        this.hasNext = this.moveToNextRLW();
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public boolean nextBit() {
        return this.nextBit;
    }

    @Override
    public int nextLength() {
        return this.nextLength;
    }

    @Override
    public void move() {
        this.move(this.nextLength);
    }

    @Override
    public void move(int bits) {
        this.nextLength -= bits;
        if (this.nextLength <= 0) {
            do {
                this.nextBit = null;
                this.updateNext();
                this.hasNext = this.moveToNextRLW();
            } while (this.nextLength <= 0 && this.hasNext);
        }
    }

    private boolean moveToNextRLW() {
        while (!this.runningHasNext() && !this.literalHasNext()) {
            if (!this.hasNextRLW()) {
                return this.nextBit != null;
            }
            this.setRLW(this.nextRLW());
            this.updateNext();
        }
        return true;
    }

    private void setRLW(RunningLengthWord rlw) {
        this.runningLength = Math.min(this.sizeInBits, this.position + 64 * (int)rlw.getRunningLength());
        this.runningBit = rlw.getRunningBit();
        this.wordPosition = this.ewahIter.literalWords();
        this.wordLength = this.wordPosition + rlw.getNumberOfLiteralWords();
    }

    private boolean runningHasNext() {
        return this.position < this.runningLength;
    }

    private boolean literalHasNext() {
        while (this.word == 0L && this.wordMask == 0L && this.wordPosition < this.wordLength) {
            this.word = this.buffer.getWord(this.wordPosition++);
            this.wordMask = 1L;
        }
        return (this.word != 0L || this.wordMask != 0L || !this.hasNextRLW()) && this.position < this.sizeInBits;
    }

    private boolean hasNextRLW() {
        return this.ewahIter.hasNext();
    }

    private RunningLengthWord nextRLW() {
        return this.ewahIter.next();
    }

    private void updateNext() {
        if (this.runningHasNext()) {
            if (this.nextBit == null || this.nextBit == this.runningBit) {
                this.nextBit = this.runningBit;
                int offset = this.runningOffset();
                this.nextLength += offset;
                this.movePosition(offset);
                this.updateNext();
            }
        } else if (this.literalHasNext()) {
            boolean b = this.currentWordBit();
            if (this.nextBit == null || this.nextBit == b) {
                this.nextBit = b;
                ++this.nextLength;
                this.movePosition(1);
                this.shiftWordMask();
                this.updateNext();
            }
        } else {
            this.moveToNextRLW();
        }
    }

    private int runningOffset() {
        return this.runningLength - this.position;
    }

    private void movePosition(int offset) {
        this.position += offset;
    }

    private boolean currentWordBit() {
        return (this.word & this.wordMask) != 0L;
    }

    private void shiftWordMask() {
        this.word &= this.wordMask ^ 0xFFFFFFFFFFFFFFFFL;
        this.wordMask <<= 1;
    }
}

