/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.googlecode.javaewah.symmetric;

import java.util.Comparator;
import shaded.com.googlecode.javaewah.BitmapStorage;
import shaded.com.googlecode.javaewah.EWAHCompressedBitmap;
import shaded.com.googlecode.javaewah.IteratingBufferedRunningLengthWord;
import shaded.com.googlecode.javaewah.datastructure.PriorityQ;
import shaded.com.googlecode.javaewah.symmetric.BitmapSymmetricAlgorithm;
import shaded.com.googlecode.javaewah.symmetric.EWAHPointer;
import shaded.com.googlecode.javaewah.symmetric.UpdateableBitmapFunction;

public class RunningBitmapMerge
implements BitmapSymmetricAlgorithm {
    @Override
    public void symmetric(UpdateableBitmapFunction f, BitmapStorage out, EWAHCompressedBitmap ... set) {
        out.clear();
        PriorityQ<EWAHPointer> h2 = new PriorityQ<EWAHPointer>(set.length, new Comparator<EWAHPointer>(){

            @Override
            public int compare(EWAHPointer arg0, EWAHPointer arg1) {
                return arg0.compareTo(arg1);
            }
        });
        f.resize(set.length);
        for (int k = 0; k < set.length; ++k) {
            EWAHPointer x = new EWAHPointer(0, new IteratingBufferedRunningLengthWord(set[k]), k);
            if (x.hasNoData()) continue;
            f.rw[k] = x;
            x.callbackUpdate(f);
            h2.toss(x);
        }
        h2.buildHeap();
        int lasta = 0;
        if (h2.isEmpty()) {
            return;
        }
        block1: while (true) {
            int a = h2.peek().endOfRun();
            f.dispatch(out, lasta, a);
            lasta = a;
            while (true) {
                if (h2.peek().endOfRun() != a) continue block1;
                EWAHPointer p = h2.peek();
                p.parseNextRun();
                p.callbackUpdate(f);
                if (p.hasNoData()) {
                    h2.poll();
                    if (!h2.isEmpty()) continue;
                    break block1;
                }
                h2.percolateDown();
            }
            break;
        }
    }
}

