/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.googlecode.javaewah32;

import shaded.com.googlecode.javaewah.IntIterator;
import shaded.com.googlecode.javaewah32.Buffer32;
import shaded.com.googlecode.javaewah32.EWAHIterator32;
import shaded.com.googlecode.javaewah32.RunningLengthWord32;

final class IntIteratorImpl32
implements IntIterator {
    private final EWAHIterator32 ewahIter;
    private final Buffer32 buffer;
    private int position;
    private int runningLength;
    private int word;
    private int wordPosition;
    private int wordLength;
    private int literalPosition;
    private boolean hasnext;

    IntIteratorImpl32(EWAHIterator32 ewahIter) {
        this.ewahIter = ewahIter;
        this.buffer = ewahIter.buffer();
        this.hasnext = this.moveToNext();
    }

    public boolean moveToNext() {
        while (!this.runningHasNext() && !this.literalHasNext()) {
            if (!this.ewahIter.hasNext()) {
                return false;
            }
            this.setRunningLengthWord(this.ewahIter.next());
        }
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.hasnext;
    }

    @Override
    public int next() {
        int answer;
        if (this.runningHasNext()) {
            answer = this.position++;
        } else {
            int t2 = this.word & -this.word;
            answer = this.literalPosition + Integer.bitCount(t2 - 1);
            this.word ^= t2;
        }
        this.hasnext = this.moveToNext();
        return answer;
    }

    private void setRunningLengthWord(RunningLengthWord32 rlw) {
        this.runningLength = 32 * rlw.getRunningLength() + this.position;
        if (!rlw.getRunningBit()) {
            this.position = this.runningLength;
        }
        this.wordPosition = this.ewahIter.literalWords();
        this.wordLength = this.wordPosition + rlw.getNumberOfLiteralWords();
    }

    private boolean runningHasNext() {
        return this.position < this.runningLength;
    }

    private boolean literalHasNext() {
        while (this.word == 0 && this.wordPosition < this.wordLength) {
            this.word = this.buffer.getWord(this.wordPosition++);
            this.literalPosition = this.position;
            this.position += 32;
        }
        return this.word != 0;
    }
}

