/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.googlecode.javaewah32;

import shaded.com.googlecode.javaewah32.Buffer32;

public final class RunningLengthWord32
implements Cloneable {
    final Buffer32 buffer;
    int position;
    public static final int RUNNING_LENGTH_BITS = 16;
    private static final int LITERAL_BITS = 15;
    public static final int LARGEST_LITERAL_COUNT = Short.MAX_VALUE;
    public static final int LARGEST_RUNNING_LENGTH_COUNT = 65535;
    private static final int RUNNING_LENGTH_PLUS_RUNNING_BIT = 131071;
    private static final int SHIFTED_LARGEST_RUNNING_LENGTH_COUNT = 131070;
    private static final int NOT_RUNNING_LENGTH_PLUS_RUNNING_BIT = -131072;
    private static final int NOT_SHIFTED_LARGEST_RUNNING_LENGTH_COUNT = -131071;

    RunningLengthWord32(Buffer32 buffer, int p) {
        this.buffer = buffer;
        this.position = p;
    }

    public int getNumberOfLiteralWords() {
        return RunningLengthWord32.getNumberOfLiteralWords(this.buffer, this.position);
    }

    static int getNumberOfLiteralWords(Buffer32 buffer, int position) {
        return buffer.getWord(position) >>> 17;
    }

    public boolean getRunningBit() {
        return RunningLengthWord32.getRunningBit(this.buffer, this.position);
    }

    static boolean getRunningBit(Buffer32 buffer, int position) {
        return (buffer.getWord(position) & 1) != 0;
    }

    public int getRunningLength() {
        return RunningLengthWord32.getRunningLength(this.buffer, this.position);
    }

    static int getRunningLength(Buffer32 buffer, int position) {
        return buffer.getWord(position) >>> 1 & 0xFFFF;
    }

    public void setNumberOfLiteralWords(int number) {
        RunningLengthWord32.setNumberOfLiteralWords(this.buffer, this.position, number);
    }

    static void setNumberOfLiteralWords(Buffer32 buffer, int position, int number) {
        buffer.orWord(position, -131072);
        buffer.andWord(position, number << 17 | 0x1FFFF);
    }

    public void setRunningBit(boolean b) {
        RunningLengthWord32.setRunningBit(this.buffer, this.position, b);
    }

    static void setRunningBit(Buffer32 buffer, int position, boolean b) {
        if (b) {
            buffer.orWord(position, 1);
        } else {
            buffer.andWord(position, -2);
        }
    }

    public void setRunningLength(int number) {
        RunningLengthWord32.setRunningLength(this.buffer, this.position, number);
    }

    static void setRunningLength(Buffer32 buffer, int position, int number) {
        buffer.orWord(position, 131070);
        buffer.andWord(position, number << 1 | 0xFFFE0001);
    }

    public int size() {
        return this.getRunningLength() + this.getNumberOfLiteralWords();
    }

    public String toString() {
        return "running bit = " + this.getRunningBit() + " running length = " + this.getRunningLength() + " number of lit. words " + this.getNumberOfLiteralWords();
    }

    public RunningLengthWord32 clone() throws CloneNotSupportedException {
        return (RunningLengthWord32)super.clone();
    }
}

