/*
 * Decompiled with CFR 0.152.
 */
package org.ndviet.library.map;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ndviet.library.math.MathHelpers;

public class MapUtils {
    private static List<String> getSegments(String segmentsPath) {
        return Arrays.asList(segmentsPath.split("\\."));
    }

    public static String getValueAsString(LinkedHashMap map, String segmentsPath) {
        List<String> segments = MapUtils.getSegments(segmentsPath);
        Object value = MapUtils.getValueAsObject((Object)map, segments.listIterator());
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public static Object getValueAsObject(Object obj, String segmentsPath) {
        List<String> segments = MapUtils.getSegments(segmentsPath);
        return MapUtils.getValueAsObject(obj, segments.listIterator());
    }

    public static Object getValueAsObject(Object obj, Iterator<String> segments) {
        if (segments.hasNext()) {
            Object currentObj;
            String segment = segments.next();
            if (obj instanceof LinkedHashMap && (currentObj = ((LinkedHashMap)obj).get(segment)) != null) {
                if (segments.hasNext()) {
                    return MapUtils.getValueAsObject(currentObj, segments);
                }
                return currentObj;
            }
        } else {
            return obj.toString();
        }
        return null;
    }

    public static <K extends Comparable, V> Map<K, V> sortByKeys(Map<K, V> map, boolean reverse) {
        LinkedList<K> keys = new LinkedList<K>(map.keySet());
        if (!reverse) {
            Collections.sort(keys);
        } else {
            Collections.sort(keys, Collections.reverseOrder());
        }
        LinkedHashMap<Comparable, V> sortedMap = new LinkedHashMap<Comparable, V>();
        for (Comparable key : keys) {
            sortedMap.put(key, map.get(key));
        }
        return sortedMap;
    }

    public static <K, V extends Comparable> Map<K, V> sortByValues(Map<K, V> map, boolean reverse) {
        LinkedList<Map.Entry<K, V>> entries = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(entries, (o1, o2) -> {
            if (MathHelpers.isCreatable(((Comparable)o1.getValue()).toString()) && MathHelpers.isCreatable(((Comparable)o2.getValue()).toString())) {
                return MathHelpers.compareNumber(((Comparable)o1.getValue()).toString(), ((Comparable)o2.getValue()).toString());
            }
            return ((Comparable)o1.getValue()).compareTo(o2.getValue());
        });
        if (reverse) {
            Collections.reverse(entries);
        }
        LinkedHashMap sortedMap = new LinkedHashMap();
        for (Map.Entry entry : entries) {
            sortedMap.put(entry.getKey(), (Comparable)entry.getValue());
        }
        return sortedMap;
    }
}

