/*
 * Decompiled with CFR 0.152.
 */
package org.ndviet.library.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.ndviet.library.configuration.AbstractConfiguration;
import org.ndviet.library.configuration.ConfigurationOrdering;
import org.ndviet.library.configuration.PropertiesConfiguration;

public class ConfigurationFactory {
    public static ConfigurationOrdering createInstance() {
        ConfigurationOrdering configurations;
        try {
            PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration();
            propertiesConfiguration.readConfigurationFrom(null);
            List<String> configurationOrdering = ConfigurationFactory.extractOrderingConfigurations(propertiesConfiguration);
            configurations = new ConfigurationOrdering(propertiesConfiguration.getValue("configuration.base"), configurationOrdering);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create Configuration instance");
        }
        return configurations;
    }

    private static List<String> extractOrderingConfigurations(AbstractConfiguration configuration) {
        ArrayList<String> listKeys = new ArrayList<String>();
        for (String key : configuration.getData().keySet()) {
            if (!key.contains("configuration.ordering")) continue;
            listKeys.add(key);
        }
        listKeys.stream().sorted().collect(Collectors.toList());
        ArrayList<String> listFiles = new ArrayList<String>();
        for (String key : listKeys) {
            if (configuration.getValue(key) == null || configuration.getValue(key).isEmpty()) continue;
            listFiles.add(configuration.getValue(key));
        }
        return listFiles;
    }
}

