/*
 * Decompiled with CFR 0.152.
 */
package org.ndviet.library.string;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringHelpers {
    public static String replaceStringUsingRegex(String input, String regex, String replace) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        return matcher.replaceAll(replace);
    }

    public static List<String> replaceListStringUsingRegex(List<String> listInput, String regex, String replace) {
        ArrayList<String> returnList = new ArrayList<String>();
        for (String input : listInput) {
            returnList.add(StringHelpers.replaceStringUsingRegex(input, regex, replace));
        }
        return returnList;
    }

    public static String getStringMatchesRegex(String input, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        ArrayList<String> listMatches = new ArrayList<String>();
        while (matcher.find()) {
            listMatches.add(matcher.group(0));
        }
        return listMatches.size() == 0 ? "" : (String)listMatches.get(0);
    }

    public static List<String> getListStringMatchesRegex(String input, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        ArrayList<String> listMatches = new ArrayList<String>();
        while (matcher.find()) {
            listMatches.add(matcher.group(0));
        }
        return listMatches;
    }

    public static List<String> getListStringMatchesListRegex(String input, List<String> listRegex) {
        ArrayList<String> listMatches = new ArrayList<String>();
        for (String regex : listRegex) {
            String value = StringHelpers.getStringMatchesRegex(input, regex);
            value = StringHelpers.replaceStringUsingRegex(value, ":|\u25cf|\\(|\\)", "").trim();
            listMatches.add(value);
        }
        return listMatches;
    }
}

